/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.SelectPreferencesParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import com.gridnine.xtrip.server.web.rest.RestServiceProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class B2BSalesContextAuthInterceptor
implements AuthRestInterceptor {
    public void authorize(RestContext context, Map<String, Object> data) throws Exception {
        SMSiteType siteType = Objects.requireNonNull((SMSiteType)data.get(IBusIbecorpContextKeys.SITE_TYPE.name()));
        if (siteType == SMSiteType.B2B) {
            this.authorizeB2B(data);
        } else {
            this.authorizeB2C(data);
        }
    }

    private void authorizeB2B(Map<String, Object> data) throws Exception {
        SalesContext result;
        RestServiceProvider.Operation operation = (RestServiceProvider.Operation)data.get(IBusRestContextKeys.REST_OPERATION.name());
        if (SelectPreferencesParameters.class.equals((Object)operation.getParamsClass())) {
            return;
        }
        EntityReference authorizedUserRef = Objects.requireNonNull((EntityReference)data.get(IBusIbecorpContextKeys.AUTHORIZED_USER.name()));
        EntityContainer authorizedUserCtr = Objects.requireNonNull((EntityContainer)data.get(IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER.name()));
        EntityReference siteRef = Objects.requireNonNull((EntityReference)data.get(IBusIbecorpContextKeys.SITE.name()));
        EntityReference currentOrg = Objects.requireNonNull((EntityReference)data.get(IBusIbecorpContextKeys.CURRENT_ORGANIZATION.name()));
        EntityReference<SalesPoint> selectedSalesPoint = (EntityReference<SalesPoint>)data.get(IBusIbecorpContextKeys.SELECTED_SALES_POINT.name());
        PersonType personType = (PersonType)data.get(IBusIbecorpContextKeys.AUTHORIZED_USER_PERSON_TYPE.name());
        Person authorizedUser = (Person)authorizedUserCtr.getEntity();
        if (!AuthorizationHelper.isValidB2BPersonTypes(authorizedUser)) {
            throw Xeption.forAdmin((String)String.format("User [%s] has not valid types [%s].", authorizedUser, CommonHelper.getEnumsCaptionsJoin(Arrays.stream(PersonType.values()).filter(AuthorizationHelper.VALID_B2B_TYPES_CRITERION).collect(Collectors.toSet()))), (Object[])new Object[0]);
        }
        if (AuthorizationHelper.isDisabledB2BPerson(authorizedUser, (EntityReference<Organization>)currentOrg)) {
            throw Xeption.forAdmin((String)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0431\u044b\u043b \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d.", (Object[])new Object[0]);
        }
        if (personType == PersonType.AGENT || personType == PersonType.WEB_AGENT) {
            result = AuthorizationHelper.getB2BSalesContextForAgent((EntityReference<Person>)authorizedUserRef, (EntityReference<SMSite>)siteRef);
        } else if (personType == PersonType.PASSENGER) {
            result = AuthorizationHelper.getB2BSalesContextForCorporant((EntityReference<Person>)authorizedUserRef, (EntityReference<SMSite>)siteRef);
        } else {
            throw Xeption.forAdmin((String)"\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u0440\u043f\u043e\u0440\u0430\u0442\u043d\u0442\u0430 \u0438\u043b\u0438 \u0430\u0433\u0435\u043d\u0442\u0430, \u043f\u0440\u043e\u0444\u0438\u043b\u044c {0} \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f {1}.", (Object[])new Object[]{authorizedUser, personType});
        }
        result.setSalesPoint(selectedSalesPoint != null ? selectedSalesPoint : CommonHelper.getSalesPoint((EntityReference<SMSite>)siteRef));
        PersonCommunication email = authorizedUser.getCommunications().stream().filter(pc -> CommunicationType.EMAIL == pc.getType()).findFirst().orElse(null);
        if (email == null) {
            throw Xeption.forAdmin((String)String.format("\u0412 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f [%s] \u043d\u0435 \u0437\u0430\u0434\u0430\u043d email.", authorizedUser.getLoginName()), (Object[])new Object[0]);
        }
        data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), result);
        data.put(IBusIbecorpContextKeys.AUTHORIZED_USER_PERSON_TYPE.name(), personType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void authorizeB2C(Map<String, Object> data) {
        SalesContext result;
        EntityReference authorizedUserRef = (EntityReference)data.get(IBusIbecorpContextKeys.AUTHORIZED_USER.name());
        EntityReference siteRef = Objects.requireNonNull((EntityReference)data.get(IBusIbecorpContextKeys.SITE.name()));
        if (authorizedUserRef != null) {
            EntityContainer authorizedUserCtr = EntityStorage.get().resolve(authorizedUserRef);
            Person authorizedUser = (Person)authorizedUserCtr.getEntity();
            if (!AuthorizationHelper.isValidB2CPersonTypes(authorizedUser)) {
                throw Xeption.forEndUser((String)String.format("User [%s] has invalid types [%s]", authorizedUser, CommonHelper.getEnumsCaptionsJoin(authorizedUser.getTypes())), (Object[])new Object[0]);
            }
            if (!authorizedUser.getTypes().contains(PersonType.PASSENGER)) throw Xeption.forEndUser((String)String.format("\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430, \u043f\u0440\u043e\u0444\u0438\u043b\u044c [%s] \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f", authorizedUser), (Object[])new Object[0]);
            result = AuthorizationHelper.getB2CSalesContextForAuthorizedPassenger((EntityReference<SMSite>)siteRef, (EntityReference<Person>)authorizedUserRef);
        } else {
            result = AuthorizationHelper.getB2CSalesContextForPassenger((EntityReference<SMSite>)siteRef);
        }
        result.setSalesPoint(CommonHelper.getSalesPoint((EntityReference<SMSite>)siteRef));
        data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), result);
        data.put(IBusIbecorpContextKeys.CURRENT_ORGANIZATION.name(), result.getClient());
        data.put(IBusIbecorpContextKeys.AUTHORIZED_USER_PERSON_TYPE.name(), PersonType.PASSENGER);
    }
}

