/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.PersonRestCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.RestBookingPerson;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class B2BSelectedPassengerConverterHelper {
    public static RestBookingPerson convertPerson2Rest(EntityContainer<Person> personCtr, BookingFile bookingFile, EntityReference<Organization> selectedOrganization) {
        RestBookingPerson result = new RestBookingPerson();
        CabinetConverterHelper.convertPerson2Rest(personCtr, result);
        B2BSelectedPassengerConverterHelper.fillCostCodes(bookingFile, personCtr, result, selectedOrganization);
        return result;
    }

    private static void fillCostCodes(BookingFile bookingFile, EntityContainer<Person> sourcePersonCtr, RestBookingPerson targetPerson, EntityReference<Organization> selectedOrganization) {
        Person sourcePerson = (Person)sourcePersonCtr.getEntity();
        targetPerson.getCostCodes().addAll(CorporateClientHelper.convertPersonCostCodes2Rest(sourcePerson.getCostCodes().stream().filter(Objects::nonNull).filter(c -> MiscUtil.equals((Object)c.getOrganization(), (Object)selectedOrganization)).collect(Collectors.toList())));
        if (bookingFile != null) {
            List baseProducts = bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(baseProduct -> ProductHandler.of((BaseProduct)baseProduct).getTravellers(baseProduct).stream().map(Traveller::getPassenger).filter(Objects::nonNull).anyMatch(person -> person.equals((Object)sourcePersonCtr.toReference()))).collect(Collectors.toList());
            if (!baseProducts.isEmpty()) {
                for (BaseProduct baseProduct2 : baseProducts) {
                    ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)baseProduct2);
                    if (!handler.isStatisticalDataAvailable(baseProduct2)) {
                        return;
                    }
                    StatisticalData statisticalData = handler.getStatisticalData(baseProduct2);
                    if (statisticalData == null) continue;
                    List targetPersonCostCodes = targetPerson.getCostCodes().stream().map(PersonRestCostCode::getCostCodeCategoryUid).collect(Collectors.toList());
                    List costCodes = statisticalData.getTravellerCostCodes().stream().filter(travellerCostCodes -> travellerCostCodes.getTraveller().getPassenger().equals((Object)sourcePersonCtr.toReference())).flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).collect(Collectors.toList());
                    List<PersonRestCostCode> personRestCostCodes = CommonConverterHelper.convertCostCodesToRest(costCodes.stream().filter(costCode -> costCode.getCostCodeProperties() != null).filter(costCode -> costCode.getCostCodeProperties().getCategory() != null).filter(costCode -> !targetPersonCostCodes.contains(costCode.getCostCodeProperties().getCategory().getCode())).collect(Collectors.toList()));
                    targetPerson.getCostCodes().addAll(personRestCostCodes);
                }
            }
            B2BSelectedPassengerConverterHelper.fillCommonCostCodes(targetPerson, selectedOrganization, bookingFile);
        }
    }

    private static void fillCommonCostCodes(RestBookingPerson restPerson, EntityReference<Organization> clientRef, BookingFile bookingFile) {
        List commonProperties = Optional.ofNullable(EntityStorage.get().resolve(clientRef)).map(EntityContainer::getEntity).map(c -> c.getCostCodeProperties().stream().filter(CostCodeProperties::isCommon).filter(ccp -> ccp.getCategory() != null).collect(Collectors.toList())).orElse(Collections.emptyList());
        if (commonProperties.isEmpty()) {
            return;
        }
        List commonCodes = commonProperties.stream().map(ccp -> ccp.getCategory().getCode()).collect(Collectors.toList());
        List baseProducts = bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).collect(Collectors.toList());
        HashMap commonValues = new HashMap();
        for (BaseProduct baseProduct : baseProducts) {
            StatisticalData statisticalData;
            ProductHandler handler = ProductHandler.of((BaseProduct)baseProduct);
            if (TicketType.FAKE == handler.getTicketType(baseProduct) || (statisticalData = handler.getStatisticalData(baseProduct)) == null) continue;
            List<CostCode> costCodes = statisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(cc -> commonCodes.contains(Optional.ofNullable(cc.getCostCodeProperties()).map(CostCodeProperties::getCategory).map(DictionaryReference::getCode).orElse(null))).collect(Collectors.toList());
            costCodes.forEach(cc -> commonValues.computeIfAbsent(cc.getCostCodeProperties().getCategory().getCode(), k -> new HashSet()).add(CommonConverterHelper.defineValueFromCostCode(cc)));
        }
        for (Map.Entry entry : commonValues.entrySet()) {
            if (((Set)entry.getValue()).size() != 1) continue;
            String value = (String)((Set)entry.getValue()).iterator().next();
            PersonRestCostCode personRestCostCode = restPerson.getCostCodes().stream().filter(cc -> MiscUtil.equals((Object)cc.getCostCodeCategoryUid(), entry.getKey())).findFirst().orElse(null);
            if (personRestCostCode != null) {
                personRestCostCode.setValue(value);
                continue;
            }
            personRestCostCode = CommonConverterHelper.createRestCostCode(commonProperties.stream().filter(ccp -> MiscUtil.equals((Object)ccp.getCategory().getCode(), entry.getKey())).findFirst().orElse(null), value);
            if (personRestCostCode == null) continue;
            restPerson.getCostCodes().add(personRestCostCode);
        }
    }
}

