/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest;

import com.google.common.collect.ImmutableMap;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.rest.TypeDiscriminator;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestBaseAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailBaggageInRailwayRoomAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailHandBaggageAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestRailPetBaggageAncillaryFee;
import java.util.Map;
import java.util.function.Function;
import org.json.JSONObject;

public class B2BTypeDiscriminator
extends TypeDiscriminator {
    private static final Function<Object, Class<?>> ANCILLARY_FEE_HANDLER = object -> {
        JSONObject travelSubjectRef = ((JSONObject)object).optJSONObject("travelSubject");
        if (travelSubjectRef == null) {
            return RestBaseAncillaryFee.class;
        }
        TravelSubject travelSubject = TravelSubject.valueOf((String)travelSubjectRef.getString("uid"));
        switch (travelSubject) {
            case AIR: {
                return RestAncillaryFee.class;
            }
            case RAILWAY: {
                JSONObject mcoCategoryRef = ((JSONObject)object).optJSONObject("mcoCategory");
                if (mcoCategoryRef == null) {
                    return RestRailAncillaryFee.class;
                }
                RailwayMcoCategory mcoCategory = RailwayMcoCategory.valueOf((String)mcoCategoryRef.getString("uid"));
                switch (mcoCategory) {
                    case HAND_BAGGAGE: {
                        return RestRailHandBaggageAncillaryFee.class;
                    }
                    case PET_BAGGAGE: {
                        return RestRailPetBaggageAncillaryFee.class;
                    }
                    case LUGGAGE_IN_RAILWAY_ROOM: {
                        return RestRailBaggageInRailwayRoomAncillaryFee.class;
                    }
                }
                return RestRailAncillaryFee.class;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported travelSubject: %s", travelSubject));
    };
    private static final Map<Class<?>, Function<Object, Class<?>>> handlers = new ImmutableMap.Builder().put(RestBaseAncillaryFee.class, ANCILLARY_FEE_HANDLER).build();

    public boolean isAwareOf(Class<?> type) {
        return handlers.containsKey(type);
    }

    protected Class<?> determineEntityTypeFromObject(Object object, Class<?> type) {
        if (handlers.containsKey(type)) {
            return handlers.get(type).apply(object);
        }
        throw new IllegalArgumentException(String.format("Unsupported product type: %s", type));
    }
}

