/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStatus;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationUnitParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.IBusApprovalContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class ApprovalApproveIntentionAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        ctx.putObject((Enum)IBusMidofficeContextKeys.ADD_TO_BOOKING_FILE, (Object)bookingFileCtr.toReference());
        ctx.putObject((Enum)IBusMidofficeContextKeys.OVERRIDE_BOOKING_FILE_CUSTOMER, (Object)Boolean.TRUE);
        ctx.putObject((Enum)IBusApprovalContextKeys.APPROVAL_BOOKING_FILE_SAVE_NEEDED, (Object)Boolean.FALSE);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_UIDS, ((BookingFile)bookingFileCtr.getEntity()).getReservations().stream().map(BaseIdentity::getUid).collect(Collectors.toSet()));
    }

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        ctx.putObject((Enum)IBusApprovalContextKeys.APPROVAL_INTENTION_APPROVE_FAILED, (Object)Boolean.TRUE);
        return false;
    }

    public void after(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation intentionReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        BookingFileOperationParameters parameters = (BookingFileOperationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS);
        Boolean saveNeeded = (Boolean)ctx.getMandatoryObject((Enum)IBusApprovalContextKeys.APPROVAL_BOOKING_FILE_SAVE_NEEDED);
        Collection oldResUdis = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_UIDS);
        Collection reservationsForTicket = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        boolean failed = BooleanUtil.nullAsFalse((Boolean)((Boolean)ctx.getObject((Enum)IBusApprovalContextKeys.APPROVAL_INTENTION_APPROVE_FAILED)));
        Integer numberOfReservations = (Integer)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION_COUNT);
        Boolean isAutoTicketing = (Boolean)ctx.getObject((Enum)IBusTravelPolicyContextKeys.IS_TICKETING_AFTER_AUTHORIZATION_APPROVAL);
        if (!failed || BooleanUtils.isTrue((Boolean)isAutoTicketing) && numberOfReservations.intValue() != bookingFile.getReservations().size()) {
            List intentionTravellers = intentionReservation.getProducts().stream().map(product -> ProductHandler.of((BaseProduct)product).getTravellers(product)).flatMap(Collection::stream).collect(Collectors.toList());
            Set otherReservationTravellers = bookingFile.getReservations().stream().filter(r -> !MiscUtil.equals((Object)r, (Object)intentionReservation)).map(Reservation::getProducts).flatMap(Collection::stream).map(GeneralProductHelper::getTravellers).flatMap(Collection::stream).collect(Collectors.toSet());
            intentionTravellers.removeAll(otherReservationTravellers);
            bookingFile.getTravellers().removeAll(intentionTravellers);
            List newReservations = bookingFile.getReservations().stream().filter(e -> !oldResUdis.contains(e.getUid())).collect(Collectors.toList());
            bookingFile.getReservations().removeIf(res -> MiscUtil.equals((Object)res.getUid(), (Object)intentionReservation.getUid()));
            boolean isFirst = true;
            for (Reservation newRes : newReservations) {
                if (isFirst) {
                    this.log.debug(String.format("Order: %s, number reservation: %s | replace the new reservation uid: %s with the old uid: %s", bookingFile.getNumber(), CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)newRes), newRes.getUid(), intentionReservation.getUid()));
                    newRes.setUid(intentionReservation.getUid());
                    bookingFile.getReservations().stream().filter(res -> res.getPreviousReservation() != null).filter(res -> MiscUtil.equals((Object)res.getPreviousReservation().getUid(), (Object)intentionReservation.getUid())).forEach(res -> res.setPreviousReservation(newRes));
                } else if (reservationsForTicket != null) {
                    reservationsForTicket.add(newRes);
                }
                isFirst = false;
            }
            List authorizedProducts = TravelPolicyAuthorizationHelper.isAuthorization((Reservation)intentionReservation) ? intentionReservation.getProducts() : Collections.emptyList();
            List newProducts = newReservations.stream().map(Reservation::getProducts).flatMap(Collection::stream).collect(Collectors.toList());
            for (BaseProduct oldProduct : authorizedProducts) {
                TravelPolicyAuthorizationParameters oldAuthorizationParameters = TravelPolicyAuthorizationHelper.getTravelPolicyAuthorizationParameters((BaseProduct)oldProduct);
                if (oldAuthorizationParameters == null) continue;
                BaseProduct newProduct = newProducts.stream().filter(pr -> this.isSameProduct((BaseProduct)pr, oldProduct)).findFirst().orElse(null);
                if (newProduct != null) {
                    newProducts.remove(newProduct);
                    TravelPolicyImpositionResult newTravelPolicyResult = TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult((BaseProduct)newProduct);
                    if (newTravelPolicyResult == null) continue;
                    newTravelPolicyResult.setAuthorizationParameters(oldAuthorizationParameters);
                    TravelPolicyAuthorizationHelper.getAllAuthorizationUnits((BaseProduct)newProduct).stream().map(TravelPolicyAuthorizationUnitParameters::getUnitAuthorization).filter(Objects::nonNull).forEach(ua -> ua.setStatus(TravelPolicyAuthorizationStatus.COMPLETED));
                    continue;
                }
                IncidentsLog.reportStackTrace((String)String.format("Order: %s: can't find same product of old product %s of reservation %s", bookingFile.getNumber(), oldProduct.getUid(), CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)intentionReservation)));
            }
            bookingFileCtr.getVersionInfo().setVersionNotes("approve intention");
        }
        parameters.setSaveBookingFile(saveNeeded.booleanValue());
    }

    private boolean isSameProduct(BaseProduct product1, BaseProduct product2) {
        ProductHandler ph = ProductHandler.of((BaseProduct)product1);
        Traveller traveller1 = GeneralProductHelper.getTraveller((BaseProduct)product1);
        DictionaryReference passengerType1 = ph.getPassengerType(product1, traveller1);
        Traveller traveller2 = GeneralProductHelper.getTraveller((BaseProduct)product2);
        DictionaryReference passengerType2 = ph.getPassengerType(product2, traveller2);
        if (traveller1 == null || traveller2 == null) {
            return false;
        }
        return MiscUtil.equals((Object)passengerType1, (Object)passengerType2) && MiscUtil.equals((Object)traveller1.getBirthday(), (Object)traveller2.getBirthday()) && MiscUtil.equals((Object)traveller1.getPassenger(), (Object)traveller2.getPassenger());
    }
}

