/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval;

import com.gridnine.xtrip.common.hotels2.model.CancellationPolicy;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.MealPlan;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionGroupResources;
import com.gridnine.xtrip.common.ibecorp.rzd.model.PlacingData;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationIntentionData;
import com.gridnine.xtrip.common.model.booking.ReservationRailIntentionData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Meal;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsServiceAvailability;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.FakeHotelProductHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.notification.ApprovalNotification;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.notification.MailCommentFindFunction;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalHelper {
    private static final Logger log = LoggerFactory.getLogger(ApprovalHelper.class);

    public static boolean isApprovalGranted() throws Exception {
        return AclHelper.isGranted(null, (String)IbeRestrictionGroupResources.GROUP_APPROVAL.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.USE.getId(), Collections.emptyList());
    }

    public static boolean isIssueGranted() throws Exception {
        return AclHelper.isGranted(null, (String)IbeRestrictionGroupResources.GROUP_ISSUE.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.USE.getId(), Collections.emptyList());
    }

    public static boolean proposalSendToApprove(EntityContainer<BookingFile> bfCtr, List<String> emails, List<String> proposalComments) {
        MailCommentFindFunction<String, Integer> getComment = (uid, num) -> num < proposalComments.size() ? (String)proposalComments.get((int)num) : null;
        return ApprovalHelper.sendToApprove(bfCtr, emails, Collections.emptyList(), getComment);
    }

    public static boolean bookingSendToApprove(EntityContainer<BookingFile> bfCtr, List<String> emails, List<String> productsToApprove, HashMap<String, String> reservationBookingComments) {
        MailCommentFindFunction<String, Integer> getComment = (uid, num) -> (String)reservationBookingComments.get(uid);
        return ApprovalHelper.sendToApprove(bfCtr, emails, productsToApprove, getComment);
    }

    private static boolean sendToApprove(EntityContainer<BookingFile> bfCtr, List<String> emails, List<String> productsToApprove, MailCommentFindFunction<String, Integer> getComment) {
        try {
            BookingFile bookingFile = (BookingFile)bfCtr.getEntity();
            Locale locale = null;
            if (bookingFile.getCustomer() != null) {
                locale = bookingFile.getCustomer().getPreferredLocale();
            }
            EntityReference agencyRef = bookingFile.getReservations().stream().map(Reservation::getSubagency).findFirst().orElse(null);
            NotificationParameters np = new NotificationParameters((EntityReference<Organization>)agencyRef, (EntityReference<Organization>)bookingFile.getCustomerProfile(), (EntityReference<SMSite>)bookingFile.getSite(), locale, bfCtr.toReference());
            ApprovalNotification notification = new ApprovalNotification(np, (BookingFile)bfCtr.getEntity(), emails, productsToApprove, getComment);
            notification.addProperty("body", NotificationHelper.formatTemplate("approval", notification.getLocale(), notification.getContext(), ApprovalHelper.class));
            MailDocument mailDocument = NotificationHelper.buildMailDocument(notification, true);
            MailServerParameters msp = notification.getOrDefaultMailServerParameters();
            return NotificationHelper.sendMail(msp, mailDocument, false);
        }
        catch (Exception ex) {
            log.error("sendToApprove failed", (Throwable)ex);
            return false;
        }
    }

    public static HotelProduct findHotelProductByOffer(List<HotelProduct> products, HotelOffer offer) {
        List<Object> filteredProducts = products.stream().filter(hp -> ApprovalHelper.isSameProductAndOfferById(hp, offer)).collect(Collectors.toList());
        if (filteredProducts.size() == 1) {
            return (HotelProduct)filteredProducts.get(0);
        }
        if (filteredProducts.isEmpty()) {
            filteredProducts = products;
        }
        return filteredProducts.stream().filter(hp -> ApprovalHelper.isSameProductAndOfferByFields(hp, offer)).min(Comparator.comparing(hp -> BookingHelper.getTotalPrice((BaseProduct)hp, (ContractType)ContractType.CLIENT))).orElseThrow(() -> Xeption.forDeveloper((String)"can't find product for offer {0}", (Object[])new Object[]{offer.getId()}));
    }

    public static List<HotelOffer> findOffersByHotelProduct(List<HotelOffer> offers, HotelProduct hp) {
        List<HotelOffer> filteredOffers = offers.stream().filter(offer -> ApprovalHelper.isSameProductAndOfferById(hp, offer)).collect(Collectors.toList());
        if (filteredOffers.size() == 1) {
            return filteredOffers;
        }
        if (filteredOffers.isEmpty()) {
            filteredOffers = offers;
        }
        return filteredOffers.stream().filter(offer -> ApprovalHelper.isSameProductAndOfferByFields(hp, offer)).collect(Collectors.toList());
    }

    private static boolean isSameProductAndOfferById(HotelProduct hp, HotelOffer offer) {
        String offerId = offer.getId();
        Room firstRoom = HotelsReservationHelper.getFirstRoom((HotelProduct)hp);
        return Stream.of(firstRoom).filter(Objects::nonNull).flatMap(r -> Stream.of(r.getId(), r.getSignature())).filter(TextUtil::nonBlank).anyMatch(id -> MiscUtil.equals((Object)id, (Object)offerId));
    }

    private static boolean isSameProductAndOfferByFields(HotelProduct hp, HotelOffer offer) {
        Room firstRoom = Objects.requireNonNull(HotelsReservationHelper.getFirstRoom((HotelProduct)hp));
        return MiscUtil.equals((Object)TextUtil.trim((String)firstRoom.getRoomName()), (Object)TextUtil.trim((String)offer.getRoomName())) && ApprovalHelper.isMealEquals(firstRoom.getMeal(), offer.getMealIncluded()) && ApprovalHelper.isCancellationPolicyEquals(hp, offer) && MiscUtil.equals((Object)hp.getTicketType(), (Object)HotelsHelper.getTicketType((HotelsServiceAvailability)offer.getAvailability())) && MiscUtil.equals((Object)hp.getSubProvider(), (Object)offer.getSubProvider()) && MiscUtil.equals((Object)hp.isTripartiteAgreement(), (Object)offer.isTripartiteContract()) && MiscUtil.equals((Object)TextUtil.trim((String)hp.getClientTariffCode()), (Object)TextUtil.trim((String)offer.getClientTariffCode()));
    }

    private static boolean isMealEquals(Meal productMeal, MealPlan offerMeal) {
        if (productMeal == null && offerMeal == null) {
            return true;
        }
        if (productMeal != null && offerMeal != null) {
            return MiscUtil.equals((Object)TextUtil.trim((String)productMeal.getCode()), (Object)TextUtil.trim((String)offerMeal.getCode()));
        }
        return false;
    }

    private static boolean isCancellationPolicyEquals(HotelProduct hp, HotelOffer offer) {
        HotelProduct offerProduct = new HotelProduct();
        String gdsCurrency = HotelsHelper.getCurrency((HotelOffer)offer);
        FakeHotelProductHelper.fillProductFromCancellationPolicy((HotelProduct)offerProduct, (CancellationPolicy)offer.getCancellationPolicy(), (Date)hp.getIssueDate(), (String)gdsCurrency);
        if (!MiscUtil.equals((Object)hp.getCancellableNow(), (Object)offerProduct.getCancellableNow())) {
            return false;
        }
        if (!MiscUtil.equals((Object)hp.isCancellable(), (Object)offerProduct.isCancellable())) {
            return false;
        }
        if (!MiscUtil.equals((Object)MiscUtil.clearTime((Date)hp.getFreeCancellationTerm()), (Object)MiscUtil.clearTime((Date)offerProduct.getFreeCancellationTerm()))) {
            return false;
        }
        if (hp.getCancellationCharges().size() != offerProduct.getCancellationCharges().size()) {
            return false;
        }
        for (int i = 0; i < hp.getCancellationCharges().size(); ++i) {
            CancellationCharge productCC = (CancellationCharge)hp.getCancellationCharges().get(i);
            CancellationCharge offerCC = (CancellationCharge)offerProduct.getCancellationCharges().get(i);
            Date now = new Date();
            if (!(productCC.getStartDate() != null && offerCC.getStartDate() != null && productCC.getStartDate().before(now) && offerCC.getStartDate().before(now) || MiscUtil.equals((Object)MiscUtil.clearTime((Date)productCC.getStartDate()), (Object)MiscUtil.clearTime((Date)offerCC.getStartDate())))) {
                return false;
            }
            if (ApprovalHelper.isCancellationPenaltyEquals(productCC.getPenalty(), offerCC.getPenalty())) continue;
            return false;
        }
        return true;
    }

    private static boolean isCancellationPenaltyEquals(RateMoney rm1, RateMoney rm2) {
        if (rm1 == null && rm2 == null) {
            return true;
        }
        if (rm1 == null || rm2 == null) {
            return false;
        }
        return MiscUtil.equals((Object)rm1.getRate(), (Object)rm2.getRate()) && ApprovalHelper.isMoneyEquals(rm1.getMoney(), rm2.getMoney());
    }

    private static boolean isMoneyEquals(Money money1, Money money2) {
        if (money1 == null && money2 == null) {
            return true;
        }
        if (money1 == null || money2 == null) {
            return false;
        }
        return MiscUtil.equals((Object)money1.getValue(), (Object)money2.getValue()) && MiscUtil.equals((Object)money1.getCurrency(), (Object)money2.getCurrency());
    }

    public static PlacingRequirements getRailIntentionPlacingRequirements(Reservation reservation) {
        return Optional.ofNullable(reservation.getIntentionData()).map(ReservationIntentionData::getRailData).map(ReservationRailIntentionData::getPlacingRequirements).map(PlacingRequirements.class::cast).orElse(null);
    }

    public static PlacingData getRailIntentionPlacingData(Reservation reservation) {
        return Optional.ofNullable(reservation.getIntentionData()).map(ReservationIntentionData::getRailData).map(ReservationRailIntentionData::getPlacingData).map(PlacingData.class::cast).orElse(null);
    }

    public static String getRailIntentionCarNumber(Reservation reservation) {
        return BookingStreamHelper.getProductsStream((Reservation)reservation, RailwayProduct.class).map(RailwayProduct::getSegments).flatMap(Collection::stream).filter(Objects::nonNull).map(RailwaySegment::getCarriageNumber).findFirst().orElse(null);
    }

    public static List<EntityReference<Person>> getSelectedPassengers(Reservation reservation) {
        return BookingStreamHelper.getBaseProductsStream((Reservation)reservation).map(pr -> ProductHandler.of((BaseProduct)pr).getTravellers(pr)).flatMap(Collection::stream).filter(Objects::nonNull).map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

