/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocumentPart;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.midoffice.helper.GdsTracingHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.IBusApprovalContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.BooleanUtils;

public class ApprovalSaveTracesAdvice
extends BaseAdvice {
    private static final String DISABLE_LOG_DOCUMENT_CUSTOM_KEY = ApprovalSaveTracesAdvice.class.getName() + ".DISABLE_LOG_DOCUMENT";
    private static final String GDS_TRACING_SETTINGS_CUSTOM_KEY = ApprovalSaveTracesAdvice.class.getName() + ".GDS_TRACING_SETTINGS";
    private String docName;
    private String partName;
    private boolean partNameStartsWith;

    public void configure(Map<String, String> params) {
        this.docName = params.get("doc-name");
        this.partName = params.get("part-name");
        this.partNameStartsWith = "true".equals(params.get("part-name-starts-with"));
    }

    public void before(MessageContext ctx) throws Exception {
        boolean isApprovalSelectCase = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusApprovalContextKeys.APPROVAL_SELECT_INTENTION_CASE)));
        if (!isApprovalSelectCase) {
            return;
        }
        Boolean disableLogDocument = (Boolean)ctx.removeObject((Enum)IBusMidofficeContextKeys.DISABLE_LOG_DOCUMENT);
        ctx.putObject(DISABLE_LOG_DOCUMENT_CUSTOM_KEY, (Object)disableLogDocument);
        GdsTracingSettings actualSettings = (GdsTracingSettings)ctx.removeObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        ctx.putObject(GDS_TRACING_SETTINGS_CUSTOM_KEY, (Object)actualSettings);
        GdsTracingSettings gdsTracingSettings = actualSettings != null ? (GdsTracingSettings)XCloneHelper.clone((XCloneable)actualSettings) : new GdsTracingSettings();
        gdsTracingSettings.setActive(true);
        gdsTracingSettings.setSaveSearchTraces(true);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS, (Object)gdsTracingSettings);
        if (!ctx.hasObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT)) {
            GdsTracingDocument document = new GdsTracingDocument();
            document.setName(this.docName);
            document.setCreated(new Date());
            ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT, (Object)document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(MessageContext ctx) {
        boolean isApprovalSelectCase = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusApprovalContextKeys.APPROVAL_SELECT_INTENTION_CASE)));
        if (!isApprovalSelectCase) {
            return;
        }
        try {
            GdsTracingDocument document = (GdsTracingDocument)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
            if (document != null) {
                EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
                Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusApprovalContextKeys.APPROVAL_RESERVATION);
                EntityContainer gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
                String gdsInfo = Optional.ofNullable(gdsAccountCtr).map(EntityContainer::getEntity).map(BaseGdsAccount::getName).orElse(null);
                document.getParts().stream().filter(Objects::nonNull).filter(p -> TextUtil.nonBlank((String)p.getName())).filter(p -> this.partNameStartsWith ? p.getName().startsWith(this.partName) : MiscUtil.equals((Object)this.partName, (Object)p.getName())).forEach(part -> {
                    Document doc = new Document();
                    doc.setContent(GdsTracingHelper.getGlobalData((GdsTracingDocumentPart)part));
                    doc.setContentType(ContentType.XML);
                    doc.setCreated(new Date());
                    String documentName = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation) + "-" + this.docName + "-" + part.getName();
                    if (TextUtil.nonBlank((String)gdsInfo) && !documentName.contains(gdsInfo)) {
                        documentName = documentName + " (" + gdsInfo + ")";
                    }
                    doc.setName(documentName);
                    doc.setTitle(documentName);
                    doc.setOwner(bookingCtr.toReference());
                    doc.setNavigationKey(reservation.getUid());
                    doc.setType(DocumentType.GDS_LOG);
                    EntityStorage.get().save(EntityContainer.create((BaseEntity)doc), false);
                });
            }
        }
        finally {
            Boolean disableLogDocument = (Boolean)ctx.removeObject(DISABLE_LOG_DOCUMENT_CUSTOM_KEY);
            ctx.putObject((Enum)IBusMidofficeContextKeys.DISABLE_LOG_DOCUMENT, (Object)disableLogDocument);
            if (Boolean.TRUE.equals(disableLogDocument)) {
                ctx.removeObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
            }
            GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.removeObject(GDS_TRACING_SETTINGS_CUSTOM_KEY);
            ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS, (Object)gdsTracingSettings);
        }
    }
}

