/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsIntentionCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.midoffice.model.BaseReservationCreationParameters;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;

public class IsIntentionCase
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        Boolean isAutoTicketingTask = (Boolean)ctx.getObject((Enum)IBusTravelPolicyContextKeys.IS_TICKETING_AFTER_AUTHORIZATION_APPROVAL);
        if (BooleanUtils.isTrue((Boolean)isAutoTicketingTask)) {
            return String.valueOf(false);
        }
        Collection reservationCreationParameters = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS);
        return String.valueOf(this.needIntention(reservationCreationParameters));
    }

    private boolean needIntention(Collection<BaseReservationCreationParameters> reservationCreationParameters) {
        for (BaseReservationCreationParameters parameters : reservationCreationParameters) {
            Object tpResult;
            GdsReservationCreationParameters castParams;
            if (parameters instanceof GdsReservationCreationParameters) {
                castParams = (GdsReservationCreationParameters)parameters;
                tpResult = castParams.getFlight().getTravelPolicyImpositionResult();
                if (!this.needIntention((TravelPolicyImpositionResult)tpResult, castParams.getFlight().getTimeLimit())) continue;
                return true;
            }
            if (parameters instanceof RzdReservationCreationParameters) {
                castParams = (RzdReservationCreationParameters)parameters;
                tpResult = castParams.getSegment().getRzdPrice().getTravelPolicyImpositionResult();
                if (!this.needIntention((TravelPolicyImpositionResult)tpResult, null)) continue;
                return true;
            }
            if (parameters instanceof HotelsIntentionCreationParameters) {
                castParams = (HotelsIntentionCreationParameters)parameters;
                tpResult = castParams.getOffers().iterator();
                while (tpResult.hasNext()) {
                    HotelOffer offer = (HotelOffer)tpResult.next();
                    TravelPolicyImpositionResult tpResult2 = offer.getTravelPolicyImpositionResult();
                    if (!this.needIntention(tpResult2, null)) continue;
                    return true;
                }
                continue;
            }
            if (!(parameters instanceof TransferReservationCreationParameters) || !this.needIntention((TravelPolicyImpositionResult)(tpResult = (castParams = (TransferReservationCreationParameters)parameters).getTripDetails().getSearchGdsResponse().getTravelPolicyImpositionResult()), null)) continue;
            return true;
        }
        return false;
    }

    private boolean needIntention(TravelPolicyImpositionResult tpResult, Date timeLimitDate) {
        return tpResult != null && tpResult.getAuthorizationParameters() != null;
    }
}

