/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class ApprovalAviaHelper {
    ApprovalAviaHelper() {
    }

    static boolean isSameFlightSegment(Segment segment, FlightSegment flightSegment) {
        return MiscUtil.equals((Object)segment.getAirline(), (Object)flightSegment.getAirline()) && MiscUtil.equals((Object)segment.getFlightNo(), (Object)flightSegment.getFlightNumber()) && MiscUtil.equals((Object)MiscUtil.clearTime((Date)segment.getStartDate()), (Object)MiscUtil.clearTime((Date)flightSegment.getDateBegin())) && MiscUtil.equals((Object)segment.getDepartureLocation(), (Object)flightSegment.getLocationBegin()) && MiscUtil.equals((Object)segment.getArriveLocation(), (Object)flightSegment.getLocationEnd());
    }

    static boolean isSameFlightFareSegment(Segment segment, FlightSegment flightSegment, DictionaryReference<PassengerType> passengerType) {
        String flightSegBrandId;
        if (!ApprovalAviaHelper.isSameFlightSegment(segment, flightSegment)) {
            return false;
        }
        FareInfo flightFareInfo = FlightHelper.getFareInfo((FlightSegment)flightSegment, passengerType);
        if (flightFareInfo == null) {
            return false;
        }
        String productSegBrandId = MiscUtil.guarded((String)GDSHelper.getBrandId((Segment)segment));
        if (!MiscUtil.equals((Object)productSegBrandId, (Object)(flightSegBrandId = MiscUtil.guarded((String)GDSHelper.getBrandId((FareInfo)flightFareInfo))), (boolean)true)) {
            return false;
        }
        return MiscUtil.equals((Object)segment.getFareBasis(), (Object)flightFareInfo.getFareBasis());
    }

    static boolean isSameFlightBrandSegment(Segment segment, FlightSegment flightSegment, DictionaryReference<PassengerType> passengerType) {
        if (!ApprovalAviaHelper.isSameFlightSegment(segment, flightSegment)) {
            return false;
        }
        FareInfo flightFareInfo = FlightHelper.getFareInfo((FlightSegment)flightSegment, passengerType);
        if (flightFareInfo == null) {
            return false;
        }
        String productSegBrandId = GDSHelper.getBrandId((Segment)segment);
        String flightSegBrandId = GDSHelper.getBrandId((FareInfo)flightFareInfo);
        if (TextUtil.isBlank((String)productSegBrandId) || TextUtil.isBlank((String)flightSegBrandId)) {
            return false;
        }
        return MiscUtil.equals((Object)productSegBrandId, (Object)flightSegBrandId);
    }

    static List<EntityReference<Person>> collectPassengers(Reservation reservation) {
        return AirProductHelper.getAirProductsStream((Reservation)reservation).map(Product::getTraveller).map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

