/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia.ApprovalAviaHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia.VariantNotFoundException;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;

public class ApprovalFindReservationFlightFareProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight;
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection gdsFlights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        List products = AirProductHelper.getAirProductsList((Reservation)reservation);
        Product firstProduct = (Product)products.get(0);
        Flight sameFareFlight = null;
        Flight sameBrandFlight = null;
        for (Flight gdsFlight : gdsFlights) {
            if (this.sameFlightFare(firstProduct, gdsFlight)) {
                sameFareFlight = gdsFlight;
                break;
            }
            if (sameBrandFlight != null || !this.sameFlightBrand(firstProduct, gdsFlight)) continue;
            sameBrandFlight = gdsFlight;
        }
        if ((flight = (Flight)MiscUtil.guarded(sameFareFlight, sameBrandFlight)) == null) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0422\u0430\u0440\u0438\u0444 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", (Object[])new Object[0]));
            throw new VariantNotFoundException(gdsFlights);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
    }

    private boolean sameFlightFare(Product firstProduct, Flight flight) {
        List productSegments = AirProductHelper.getSegments((Collection)firstProduct.getSegmentTariffs());
        List flightSegments = FlightHelper.getSegments((Flight)flight);
        if (productSegments.size() != flightSegments.size()) {
            return false;
        }
        for (int i = 0; i < productSegments.size(); ++i) {
            FlightSegment flightSegment;
            Segment segment = (Segment)productSegments.get(i);
            if (ApprovalAviaHelper.isSameFlightFareSegment(segment, flightSegment = (FlightSegment)flightSegments.get(i), (DictionaryReference<PassengerType>)firstProduct.getPassengerType())) continue;
            return false;
        }
        return true;
    }

    private boolean sameFlightBrand(Product firstProduct, Flight flight) {
        List productSegments = AirProductHelper.getSegments((Collection)firstProduct.getSegmentTariffs());
        List flightSegments = FlightHelper.getSegments((Flight)flight);
        if (productSegments.size() != flightSegments.size()) {
            return false;
        }
        for (int i = 0; i < productSegments.size(); ++i) {
            FlightSegment flightSegment;
            Segment segment = (Segment)productSegments.get(i);
            if (ApprovalAviaHelper.isSameFlightBrandSegment(segment, flightSegment = (FlightSegment)flightSegments.get(i), (DictionaryReference<PassengerType>)firstProduct.getPassengerType())) continue;
            return false;
        }
        return true;
    }
}

