/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia.ApprovalAviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApprovalFindReservationFlightProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection gdsFlights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Map<Traveller, List<BaseProduct>> travellerProductsMap = CommonHelper.getTravellerProductsMap(reservation);
        List productSegments = travellerProductsMap.values().iterator().next().stream().filter(Product.class::isInstance).map(Product.class::cast).map(Product::getSegmentTariffs).map(AirProductHelper::getSegments).flatMap(Collection::stream).collect(Collectors.toList());
        Flight flight = gdsFlights.stream().filter(fl -> this.sameFlight(productSegments, (Flight)fl)).findFirst().orElse(null);
        if (flight == null) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0435\u0440\u0435\u043b\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", (Object[])new Object[0]));
            throw Xeption.forEndUser((String)"\u041f\u0435\u0440\u0435\u043b\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
    }

    private boolean sameFlight(List<Segment> productSegments, Flight flight) {
        List flightSegments = FlightHelper.getSegments((Flight)flight);
        if (productSegments.size() != flightSegments.size()) {
            return false;
        }
        for (int i = 0; i < productSegments.size(); ++i) {
            FlightSegment flightSegment;
            Segment segment = productSegments.get(i);
            if (ApprovalAviaHelper.isSameFlightSegment(segment, flightSegment = (FlightSegment)flightSegments.get(i))) continue;
            return false;
        }
        return true;
    }
}

