/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.IntentionStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyApplicable;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia.ApprovalAviaHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia.VariantNotFoundException;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.AviaSelectIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SelectIntentionResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.TransportSearchResultBuilder;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.TransportSearchCommonData;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApprovalFlightsResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        SelectIntentionResult result = (SelectIntentionResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        PriceComponentsParameters priceParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), salesContext);
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        reservation.setIntentionStatus(IntentionStatus.VARIANT_NOT_FOUND);
        SMStep2Settings step2Settings = Objects.requireNonNull(CommonHelper.getStep2Settings((EntityReference<SMSite>)siteRef));
        PriceDisplayStyle displayStyle = step2Settings.getPriceDisplayStyle();
        boolean showGdsAccountName = siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_AVIA);
        VariantNotFoundException variantNotFoundEx = (VariantNotFoundException)callback.getException();
        if (CollectionUtil.isEmpty(variantNotFoundEx.getFlights())) {
            throw Xeption.forDeveloper((String)"flight fares are empty", (Object[])new Object[0]);
        }
        TripParameters tripParams = new TripParameters();
        tripParams.setBookingFileRef(bookingCtr.toReference());
        List<EntityReference<Person>> passengers = ApprovalAviaHelper.collectPassengers(reservation);
        Map<String, ExchangeRateData> currencyExchangeRateDataMap = CommonConverterHelper.getCurrencyExchangeRateDataMap(variantNotFoundEx.getFlights(), salesContext);
        AviaSelectIntentionData data = new AviaSelectIntentionData();
        data.setVariantNotFound(true);
        variantNotFoundEx.getFlights().stream().filter(flight -> !CommonConverterHelper.shouldExcludeFromSearchResults((TravelPolicyApplicable)flight)).map(flight -> {
            try {
                return AviaConverterHelper.convertFlightSearchItem2Rest(flight, priceParameters, displayStyle, false, (EntityReference<Organization>)salesContext.getClient(), passengers, tripParams, showGdsAccountName, step2Settings, currencyExchangeRateDataMap);
            }
            catch (Exception ex) {
                IncidentsHelper.addStackTraceElement((Throwable)ex, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"GdsAccount", (String)flight.getGdsAccount().getCaption()), IncidentsHelper.getContextStackTraceElement((String)"Flight", (String)FlightHelper.toIdentifiableString((Flight)flight))});
                IncidentsLog.reportException((String)"failed converting flight to restFlight", (Throwable)ex);
                return null;
            }
        }).filter(Objects::nonNull).forEach(data.getFlights()::add);
        boolean hasTravelPolicy = variantNotFoundEx.getFlights().stream().anyMatch(fl -> fl.getTravelPolicyImpositionResult() != null);
        TransportSearchResultBuilder.fillTransportSearchCommonData((TransportSearchCommonData)data, siteType, salesContext, Targets.SEARCH_RESULT_SORT_TYPE_AVIA, hasTravelPolicy);
        result.setAviaData(data);
    }
}

