/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationIntentionData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia.ApprovalAviaHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ApprovalPrepareContextForSearchFlightsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ReservationIntentionData intentionData = reservation.getIntentionData();
        if (intentionData == null || intentionData.getAviaData() == null) {
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)this.buildFlightSearchParameters(reservation));
        } else {
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)intentionData.getAviaData().getFlightSearchParameters());
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)intentionData.getAviaData().getFlight());
        }
        ctx.putObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS, ApprovalHelper.getSelectedPassengers(reservation));
        ctx.putObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNT, (Object)EntityStorage.get().resolve(reservation.getGdsNameInfo().getOnlineGdsAccount()));
        TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
        travelPolicyParams.setClientRef(reservation.getBookingFile().getCustomerProfile());
        travelPolicyParams.getPersons().addAll(ApprovalAviaHelper.collectPassengers(reservation));
        ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
    }

    @Deprecated
    private FlightSearchParameters buildFlightSearchParameters(Reservation reservation) {
        List products = AirProductHelper.getAirProductsList((Reservation)reservation);
        Product firstProduct = (Product)products.get(0);
        List segments = AirProductHelper.getSegments((Collection)firstProduct.getSegmentTariffs());
        Segment firstSegment = (Segment)segments.get(0);
        FlightSearchParameters result = new FlightSearchParameters();
        result.setServiceClass(firstSegment.getServiceClass());
        result.getPreferredAirlines().add(firstProduct.getCarrier());
        result.setSkipConnected(AirProductHelper.isDirect((Product)firstProduct));
        AirProductHelper.getProductSegmentsStream((Product)firstProduct).map(seg -> {
            RouteSegment rs = new RouteSegment();
            rs.setLocationBegin(seg.getDepartureLocation());
            rs.setLocationEnd(seg.getArriveLocation());
            rs.setDate(MiscUtil.clearTime((Date)seg.getStartDate()));
            rs.setAirline(seg.getAirline());
            rs.setFlightNumber(seg.getFlightNo());
            return rs;
        }).forEach(result.getRoute()::add);
        products.stream().map(Product::getPassengerType).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((pt, count) -> {
            SeatPreferences sr = new SeatPreferences();
            sr.setPassengerType(pt);
            sr.setCount(count.intValue());
            result.getSeats().add(sr);
        });
        return result;
    }
}

