/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.IntentionStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.avia.FlightDataWrapper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia.ApprovalAviaHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.selectFlight.B2BSelectFlightResultConverter;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BSelectFlightResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.AviaSelectIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SelectIntentionResult;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SelectFlightResult;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;

public class ApprovalSelectFlightResultConverter
extends B2BSelectFlightResultConverter {
    @Override
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        SelectIntentionResult result = (SelectIntentionResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        PriceComponentsParameters priceParameters = this.getPriceConverterParameters(ctx);
        FlightDataWrapper dataWrapper = new FlightDataWrapper();
        dataWrapper.setBookingFile(bookingCtr.toReference());
        dataWrapper.setClient(Objects.requireNonNull(salesContext.getClient()));
        dataWrapper.getPassengers().addAll(ApprovalAviaHelper.collectPassengers(reservation));
        B2BSelectFlightResult selectFlightResult = this.buildSelectFlightResult(dataWrapper, null, flight, (EntityReference<SMSite>)siteRef, siteType, priceParameters);
        AviaSelectIntentionData data = new AviaSelectIntentionData();
        data.setSelectFlight((SelectFlightResult)selectFlightResult);
        result.setAviaData(data);
        BigDecimal oldPrice = BookingHelper.getTotalPrice((Reservation)reservation, (ContractType)ContractType.CLIENT);
        BigDecimal newPrice = FlightHelper.calcTotalPrice((Flight)flight, (ContractType)ContractType.CLIENT);
        Boolean isAutoTicketing = (Boolean)ctx.getObject((Enum)IBusTravelPolicyContextKeys.IS_TICKETING_AFTER_AUTHORIZATION_APPROVAL);
        if (BooleanUtils.isTrue((Boolean)isAutoTicketing) && !TravelPolicyAuthorizationHelper.isPriceChangingInLimit((Reservation)reservation, (BigDecimal)newPrice, (BigDecimal)oldPrice)) {
            reservation.setIntentionStatus(IntentionStatus.VARIANT_PRICE_CHANGED);
            ctx.putObject((Enum)IBusMidofficeContextKeys.PRICE_CHANGED, (Object)true);
            throw Xeption.forDeveloper((String)"\u0426\u0435\u043d\u0430 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0430\u0441\u044c \u0438 \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u043b\u0438\u043c\u0438\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438", (Object[])new Object[0]);
        }
        if (!MiscUtil.equals((Object)oldPrice, (Object)newPrice)) {
            reservation.setIntentionStatus(IntentionStatus.VARIANT_PRICE_CHANGED);
            result.setPriceChanged(true);
            result.setOldPrice(oldPrice);
            result.setNewPrice(newPrice);
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u043e\u0432\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0435\u0440\u0435\u043b\u0435\u0442\u0430 {0} \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0441\u0442\u0430\u0440\u043e\u0439 {1}", (Object[])new Object[]{newPrice, oldPrice}));
        }
    }
}

