/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.avia;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightMultiTicketItem;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.SegmentSpecialServiceRequest;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.IBusIbeCorpContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AviaApprovalCreateReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters params = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Flight flight = params.getFlight();
        EntityContainer gdsAccountCtr = EntityStorage.get().resolve(flight.getGdsAccount());
        Reservation reservation = new Reservation();
        Date now = new Date();
        reservation.setAccountCode(flight.getAccountCode());
        reservation.setCorporateId(flight.getCorporateId());
        reservation.getGdsNameInfo().setOnlineGdsAccount(flight.getGdsAccount());
        reservation.setPricingDate(now);
        reservation.setResDate(now);
        reservation.setTimeLimit(flight.getTimeLimit());
        reservation.setBookingAgent(salesContext.getAgent());
        reservation.setSalesPoint(salesContext.getSalesPoint());
        reservation.setSubagency(salesContext.getSubagency());
        reservation.setType(ReservationType.IBE);
        if (reservation.getSubagency() == null) {
            if (salesContext.getAgency() != null) {
                reservation.setSubagency(salesContext.getAgency());
            } else {
                try {
                    EntityContainer spCtr = EntityStorage.get().resolve(salesContext.getSalesPoint());
                    if (spCtr != null) {
                        reservation.setSubagency(((SalesPoint)spCtr.getEntity()).getAgency());
                    }
                }
                catch (Exception e) {
                    this.log.error("failed loading agency", (Throwable)e);
                }
            }
        }
        String number = SequenceNumberHelper.generateNumber((String)"approval-reservation", ProductIndex.class, SearchQueryHelper::getRecordLocatorSearchCriterionForProductIndex, (String)"AA", null);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.IBE, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)number);
        ReservationGdsNameInfoHelper.setRulesGdsNameFromAccount((Reservation)reservation, (EntityContainer)gdsAccountCtr);
        for (GdsTraveller gdsTraveller : params.getGdsTravellers()) {
            this.createProducts(flight, gdsTraveller, travellers, salesContext).forEach(p -> BookingHelper.addProduct((Reservation)reservation, (BaseProduct)p));
        }
        Boolean isProposal = (Boolean)ctx.getObject((Enum)IBusIbeCorpContextKeys.IS_PROPOSAL);
        reservation.setProposal(Boolean.TRUE.equals(isProposal));
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, (Object)gdsAccountCtr);
    }

    private List<Product> createProducts(Flight flight, GdsTraveller gdsTraveller, Collection<Traveller> travellers, SalesContext salesCtx) throws Exception {
        EntityReference blankOwnerRef = flight.getBlankOwner();
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
        if (blankOwnerCtr == null) {
            throw Xeption.forAdmin((String)"\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u0430 {0} \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445", (Object[])new Object[]{blankOwnerRef});
        }
        if (((Organization)blankOwnerCtr.getEntity()).getAirline() == null) {
            throw Xeption.forAdmin((String)"\u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f", (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).getCode()});
        }
        Airline blankOwnerAirline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerCtr.getEntity()).getAirline());
        if (blankOwnerAirline == null) {
            throw Xeption.forAdmin((String)"\u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f {0}, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c {1}, \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).getAirline(), ((Organization)blankOwnerCtr.getEntity()).getCode()});
        }
        if (StringUtils.isBlank((String)blankOwnerAirline.getAirlineNumber())) {
            throw Xeption.forAdmin((String)"\u0443 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 {0}, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c {1}, \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u043a\u043e\u0434", (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).getAirline(), ((Organization)blankOwnerCtr.getEntity()).getCode()});
        }
        Product prodTemplate = new Product();
        prodTemplate.setGdsCurrency(flight.getGdsCurrencyCode());
        prodTemplate.setSalesOriginProvider(flight.getSalesOriginProvider());
        prodTemplate.setSalesOriginContent(flight.getSalesOriginContent());
        prodTemplate.setEticket(true);
        prodTemplate.setTicketType(TicketType.OWN);
        prodTemplate.setCashier(salesCtx.getAgent());
        prodTemplate.setCashierCode(((Person)EntityStorage.get().resolve(salesCtx.getAgent()).getEntity()).getCode());
        prodTemplate.setSalesPoint(salesCtx.getSalesPoint());
        AirProductHelper.setSalesChain((Product)prodTemplate, (SalesChain)flight.getSalesChain());
        prodTemplate.setBlankOwnerRef(blankOwnerRef);
        prodTemplate.setBlankOwnerNumber(blankOwnerAirline.getAirlineNumber());
        prodTemplate.setBlankType(AviaApprovalCreateReservationProcessor.getBlankType((EntityReference<Organization>)blankOwnerRef));
        prodTemplate.setProductCategory(ProductCategory.AIR);
        prodTemplate.setStatus(ProductStatus.INTENTION);
        prodTemplate.setTariffType(TariffType.REGULAR);
        prodTemplate.setPassengerType(gdsTraveller.getPassengerType());
        Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
        prodTemplate.setIssueDate(new Date());
        AirProductHelper.getContractRelations((Product)prodTemplate);
        ArrayList<Product> result = new ArrayList<Product>();
        if (flight.getMultiTicketBreakdown().size() < 2) {
            prodTemplate.setTraveller(traveller);
            this.updateProduct(prodTemplate, flight, gdsTraveller, (DictionaryReference<Airline>)flight.getCarrier(), flight.getSegmentTariffs(), flight.getFares(), flight.getTaxes());
            AirProductHelper.updateRecordNumbers((Product)prodTemplate);
            result.add(prodTemplate);
        } else {
            for (FlightMultiTicketItem mti : flight.getMultiTicketBreakdown()) {
                Product prod = (Product)XCloneHelper.clone((XCloneable)prodTemplate, (boolean)true);
                ProductHandler.of((BaseProduct)prod).setOrReplaceTraveller((BaseProduct)prod, traveller);
                this.updateProduct(prod, flight, gdsTraveller, (DictionaryReference<Airline>)mti.getCarrier(), mti.getSegmentTariffs(), mti.getFares(), mti.getTaxes());
                AirProductHelper.updateRecordNumbers((Product)prod);
                result.add(prod);
            }
        }
        for (AncillaryFee ancillaryFee : flight.getAncillaryFees()) {
            if (!ancillaryFee.isSelected() || !MiscUtil.equals((Object)ancillaryFee.getPassengerType(), (Object)gdsTraveller.getPassengerType())) continue;
            Product mco = GDSHelper.buildMcoProduct((Product)prodTemplate, (AncillaryFee)ancillaryFee);
            mco.setStatus(ProductStatus.INTENTION);
            result.add(mco);
        }
        return result;
    }

    private void updateProduct(Product prod, Flight flight, GdsTraveller gdsTraveller, DictionaryReference<Airline> carrier, List<FlightSegmentTariff> flightSegmentTariffs, List<FlightFare> fares, List<FlightTax> taxes) {
        prod.setCarrier(carrier);
        prod.setCarrierNumber(((Airline)DictionaryCache.get().resolveReference(prod.getCarrier())).getAirlineNumber());
        int segmentNumber = 0;
        HashMap<FlightSegmentTariff, SegmentTariff> segmentTariffs = new HashMap<FlightSegmentTariff, SegmentTariff>();
        for (FlightSegmentTariff fst : flightSegmentTariffs) {
            SegmentTariff st = new SegmentTariff();
            for (FlightSegment fs : fst.getSegments()) {
                ++segmentNumber;
                Segment seg = new Segment();
                seg.setAirline(fs.getAirline());
                seg.setArriveLocation(fs.getLocationEnd());
                seg.setArriveTerminal(fs.getTerminalEnd());
                seg.setClassOfSvcCode(fs.getBookingClass());
                seg.setServiceClass(fs.getServiceClass());
                seg.setDepartureLocation(fs.getLocationBegin());
                seg.setDepartTerminal(fs.getTerminalBegin());
                seg.setBoard(fs.getBoard());
                seg.setFlightDuration(Integer.valueOf(fs.getTravelDuration()));
                seg.setFlightNo(fs.getFlightNumber());
                seg.setStarting(fs.isStarting());
                seg.setStartDate(fs.getDateBegin());
                seg.setEndDate(fs.getDateEnd());
                seg.setNoOfStops(Integer.valueOf(fs.getStops()));
                seg.getTechStopInfos().addAll(fs.getTechStopInfos());
                seg.setCodeShareCarrier(fs.getOperatingAirline());
                seg.setCodeShareFlightNo(fs.getOperatingFlightNumber());
                seg.setCodeShare(!seg.getAirline().equals((Object)seg.getCodeShareCarrier()));
                seg.setRecordNumber(segmentNumber);
                for (SegmentSpecialServiceRequest sssr : gdsTraveller.getSsrs()) {
                    if (!sssr.getSegmentUid().equals(fs.getUid())) continue;
                    seg.getSsrs().add(sssr.getSpecialServiceRequest());
                }
                for (FareInfo fareInfo : fs.getFareInfos()) {
                    if (!prod.getPassengerType().equals((Object)fareInfo.getPassengerType())) continue;
                    seg.setFareBasis(fareInfo.getFareBasis());
                    seg.setRemarksSearchContext(fareInfo.getRemarksSearchContext());
                    seg.setLuggageInfo(fareInfo.getLuggageInfo());
                    seg.setFareDetails(fareInfo.getFareDetails());
                    break;
                }
                PenaltiesInfo penaltiesInfo = (PenaltiesInfo)flight.getPenaltiesInfos().get(prod.getPassengerType());
                seg.setPenaltiesInfo(penaltiesInfo);
                st.getSegments().add(seg);
            }
            prod.getSegmentTariffs().add(st);
            segmentTariffs.put(fst, st);
        }
        for (FlightFare ffare : fares) {
            if (!ffare.getPassengerType().equals((Object)gdsTraveller.getPassengerType())) continue;
            ProductFare fare = new ProductFare();
            Money baseAmount = ffare.getBaseAmount();
            if (null == baseAmount && ffare.getEquivalentAmount() != null) {
                baseAmount = MoneyHelper.buildMoney((BigDecimal)ffare.getEquivalentAmount(), (String)((String)MiscUtil.guarded((Object)flight.getGdsCurrencyCode(), (Object)DictHelper.getLocalCurrency())));
            }
            fare.setBaseFare(baseAmount);
            fare.setEquivalentFare(ffare.getEquivalentAmount());
            fare.setSegmentTariff((SegmentTariff)segmentTariffs.get(ffare.getSegmentTariff()));
            prod.getFares().add(fare);
        }
        for (FlightTax fTax : taxes) {
            if (!fTax.getPassengerType().equals((Object)gdsTraveller.getPassengerType())) continue;
            Tax tax = new Tax();
            tax.setAmount(fTax.getBaseAmount());
            tax.setEquivalentAmount(fTax.getEquivalentAmount());
            tax.setSegmentTariff((SegmentTariff)segmentTariffs.get(fTax.getSegmentTariff()));
            tax.setCode(fTax.getCode());
            prod.getTaxes().add(tax);
        }
    }

    private static DictionaryReference<BlankType> getBlankType(EntityReference<Organization> blankOwner) {
        for (BlankType blankType : BookingHelper.getBlankTypesByVendor(blankOwner)) {
            if (blankType.getBlankCategory() != BlankCategory.ETICKET || blankType.getProductCategory() != ProductCategory.AIR) continue;
            return blankType.toReference();
        }
        throw Xeption.forAdmin((String)"\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0438\u043f \u0431\u043b\u0430\u043d\u043a\u0430 \u0434\u043b\u044f \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u0430 {0}", (Object[])new Object[]{blankOwner});
    }
}

