/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.hotels;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.CreateIntentionReservationResult;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsIntentionCreationParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationHotelIntentionData;
import com.gridnine.xtrip.common.model.booking.ReservationIntentionData;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;

public class HotelsApprovalCreateReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        HotelsIntentionCreationParameters parameters = (HotelsIntentionCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        List offers = parameters.getOffers();
        EntityReference gdsAccount = ((HotelOffer)offers.get(0)).getGdsAccount();
        CreateIntentionReservationResult result = new CreateIntentionReservationResult();
        Reservation reservation = HotelsHelper.buildProposalReservation((EntityReference)gdsAccount, (SalesContext)salesContext, (HotelCard)parameters.getHotelCard(), (List)offers, arg_0 -> ((MessageContext)ctx).addMessage(arg_0));
        reservation.setType(ReservationType.IBE);
        HotelsReservationHelper.updateTimeLimit((Reservation)reservation);
        Date now = new Date();
        reservation.getProducts().stream().filter(p -> p instanceof HotelProduct).map(HotelProduct.class::cast).forEach(p -> {
            p.setStatus(ProductStatus.INTENTION);
            p.setIssueDate(now);
        });
        reservation.setNotes(parameters.getComments());
        result.getReservations().add(reservation);
        ReservationIntentionData intentionData = new ReservationIntentionData();
        intentionData.setHotelData(new ReservationHotelIntentionData());
        intentionData.getHotelData().getOffers().addAll(offers);
        reservation.setIntentionData(intentionData);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_CREATE_INTENTION_RESERVATION_RESULT, (Object)result);
    }
}

