/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.hotels;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class HotelsApprovalFilterResponse
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HotelCard hotelCard = (HotelCard)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD);
        if (hotelCard == null) {
            return;
        }
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List products = BookingStreamHelper.getProductsStream((Reservation)reservation, HotelProduct.class).collect(Collectors.toList());
        ArrayList<XCloneable> result = new ArrayList<XCloneable>();
        for (HotelProduct product : products) {
            List<HotelOffer> sameOffers = ApprovalHelper.findOffersByHotelProduct(hotelCard.getHotelOffers(), product);
            if (sameOffers.isEmpty()) {
                throw Xeption.forDeveloper((String)"can't find offer for product with uid {0}", (Object[])new Object[]{product.getUid()});
            }
            if (sameOffers.size() > 1) {
                String offerIds = sameOffers.stream().map(HotelOffer::getId).collect(Collectors.joining(", "));
                throw Xeption.forDeveloper((String)"for product with uid {0} found many offers {1}", (Object[])new Object[]{product.getUid(), offerIds});
            }
            result.add(XCloneHelper.clone((XCloneable)((XCloneable)sameOffers.get(0))));
        }
        hotelCard.getHotelOffers().clear();
        hotelCard.getHotelOffers().addAll(result);
    }
}

