/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.hotels;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IntentionStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.HotelSelectIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SelectIntentionResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelCard;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.HotelPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class HotelsApprovalResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        com.gridnine.xtrip.common.hotels2.model.HotelCard hotelCard = (com.gridnine.xtrip.common.hotels2.model.HotelCard)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD);
        PriceComponentsParameters priceComponentsParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
        EntityContainer bfCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        SelectIntentionResult result = (SelectIntentionResult)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusRestContextKeys.REST_RESULT, SelectIntentionResult::new);
        HotelSelectIntentionData data = new HotelSelectIntentionData();
        List<EntityReference<Person>> persons = CommonHelper.getReservationTravellersStream(reservation).map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toList());
        EntityReference clientRef = reservation.getBookingFile().getCustomerProfile();
        boolean isAgency = !ProfileHelper.isRetailProfile((EntityReference)clientRef);
        HotelCard restCard = HotelsConverterHelper.convertHotelCardWithOffers(hotelCard, priceComponentsParameters, isAgency, (EntityReference<Organization>)clientRef, persons, (EntityReference<BookingFile>)(bfCtr != null ? bfCtr.toReference() : null));
        data.setHotelCard(restCard);
        result.setHotelData(data);
        Price offerPrice = HotelPriceComponents.builder((HotelOffer)hotelCard.getHotelOffers().get(0), priceComponentsParameters).build().createPrice();
        BigDecimal newPrice = offerPrice.getTotal().getAmount();
        BigDecimal oldPrice = BookingHelper.getTotalPrice((Reservation)reservation, (ContractType)ContractType.CLIENT);
        oldPrice = CommonConverterHelper.convertMoney2Rest(oldPrice, offerPrice.getTotal().getCurrencyCode()).getAmount();
        Boolean isAutoTicketing = (Boolean)ctx.getObject((Enum)IBusTravelPolicyContextKeys.IS_TICKETING_AFTER_AUTHORIZATION_APPROVAL);
        if (BooleanUtils.isTrue((Boolean)isAutoTicketing) && !TravelPolicyAuthorizationHelper.isPriceChangingInLimit((Reservation)reservation, (BigDecimal)newPrice, (BigDecimal)oldPrice)) {
            reservation.setIntentionStatus(IntentionStatus.VARIANT_PRICE_CHANGED);
            ctx.putObject((Enum)IBusMidofficeContextKeys.PRICE_CHANGED, (Object)true);
            throw Xeption.forDeveloper((String)"\u0426\u0435\u043d\u0430 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0430\u0441\u044c \u0438 \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u043b\u0438\u043c\u0438\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438", (Object[])new Object[0]);
        }
        if (!MiscUtil.equals((Object)oldPrice, (Object)newPrice)) {
            reservation.setIntentionStatus(IntentionStatus.VARIANT_PRICE_CHANGED);
            result.setPriceChanged(true);
            result.setOldPrice(oldPrice);
            result.setNewPrice(newPrice);
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u043e\u0432\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043d\u043e\u043c\u0435\u0440\u0430 {0} \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0441\u0442\u0430\u0440\u043e\u0439 {1}", (Object[])new Object[]{newPrice, oldPrice}));
        }
    }
}

