/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.hotels;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.RoomInfo;
import com.gridnine.xtrip.common.hotels2.model.SearchOffersParameters;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class HotelsApprovalSetRequestParams
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNT, (Object)EntityStorage.get().resolve(reservation.getGdsNameInfo().getOnlineGdsAccount()));
        SearchOffersParameters sop = new SearchOffersParameters();
        LinkedList<RoomInfo> roomInfos = new LinkedList<RoomInfo>();
        List hotelProducts = reservation.getProducts().stream().map(baseProduct -> (HotelProduct)baseProduct).collect(Collectors.toList());
        for (HotelProduct hotelProduct : hotelProducts) {
            List travellers = hotelProduct.getTravellers();
            for (Room room : hotelProduct.getRooms()) {
                RoomInfo rf = new RoomInfo();
                rf.setStandardNumberOfGuests(room.getNumberOfPeople().intValue());
                for (Traveller traveller : travellers) {
                    rf.getTravellers().add(traveller);
                }
                roomInfos.add(rf);
            }
        }
        sop.getRoomsInfo().addAll(roomInfos);
        sop.setCountry(((HotelProduct)hotelProducts.get(0)).getHotelCountry());
        sop.setCity(((HotelProduct)hotelProducts.get(0)).getHotelLocation());
        sop.setProviderHotelCode(((HotelProduct)hotelProducts.get(0)).getProviderHotelCode());
        sop.setCheckInDate(MiscUtil.toDateTime((Date)((Room)((HotelProduct)hotelProducts.get(0)).getRooms().get(0)).getCheckInDate()));
        sop.setCheckOutDate(MiscUtil.toDateTime((Date)((Room)((HotelProduct)hotelProducts.get(0)).getRooms().get(0)).getCheckOutDate()));
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_OFFERS_PARAMS, (Object)sop);
    }
}

