/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.notification;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.ibecorp.rzd.model.PlacingData;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RailService;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Location;
import com.gridnine.xtrip.common.model.booking.xtriphotels.XtripHotelProductHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.NotificationSettings;
import com.gridnine.xtrip.common.model.ibecorp.railway.dict.RailwayServiceClass;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.GeoDistanceUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.notification.MailCommentFindFunction;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.SiteNotification;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;

public class ApprovalNotification
extends SiteNotification {
    protected DataModel model;
    private static final Date NULL_DATE = new Date(0L);

    protected MailTemplate getNotificationTemplate(NotificationsActionSet actionSet) {
        return actionSet.getNotificationTemplate();
    }

    public ApprovalNotification(NotificationParameters parameters, Supplier<NotificationSettings> notificationSettingsSupplier) {
        super(parameters, Collections.emptyList(), notificationSettingsSupplier, () -> Targets.NOTIFICATION_TEMPLATE_SITE_APPROVAL);
    }

    public ApprovalNotification(NotificationParameters parameters, BookingFile bookingFile, List<String> emails, List<String> productsToApprove, MailCommentFindFunction<String, Integer> function) throws Exception {
        this(parameters, () -> NotificationHelper.getNotificationSettings(bookingFile, NotificationSettings::isUseSiteSettings));
        this.init(parameters, bookingFile, emails, productsToApprove, function);
    }

    protected void init(NotificationParameters parameters, BookingFile bookingFile, List<String> emails, List<String> productsToApprove, MailCommentFindFunction<String, Integer> function) throws Exception {
        this.addReservationProperties(ApprovalNotification.getReservation(productsToApprove, bookingFile));
        this.model = new DataModel(bookingFile, productsToApprove, parameters.getLocale(), function);
        this.addProperty("model", this.model);
        emails.stream().filter(TextUtil::nonBlank).map(String::trim).forEach(this::addOtherRecipient);
        if (!this.model.getHotelGroups().isEmpty()) {
            this.addImage("iconHotel.png");
            this.addImage("iconStar.png");
        }
        if (!this.model.getAirGroups().isEmpty()) {
            this.addImage("iconAir.png");
        }
        if (!this.model.getRailwayGroups().isEmpty()) {
            this.addImage("iconRailway.png");
        }
        if (!this.model.getTransferGroups().isEmpty()) {
            this.addImage("iconTransfer.png");
        }
    }

    private static Reservation getReservation(List<String> productsToApprove, BookingFile bookingFile) {
        Reservation reservation = productsToApprove.isEmpty() ? (Reservation)BookingStreamHelper.reservationStreamSafe((BookingFile)bookingFile).findFirst().get() : bookingFile.getReservations().stream().map(Reservation::getProducts).flatMap(Collection::stream).filter(bp -> productsToApprove.contains(bp.getUid())).findAny().get().getReservation();
        return reservation;
    }

    protected void addImage(String fileName) throws Exception {
        byte[] imgBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("templates/" + fileName));
        byte[] imgBytesAsBase64 = Base64.encodeBase64((byte[])imgBytes);
        String imgDataAsBase64 = new String(imgBytesAsBase64);
        String imgAsBase64 = "data:image/png;base64," + imgDataAsBase64;
        if (fileName.contains(".svg")) {
            imgAsBase64 = "data:image/svg+xml;base64," + imgDataAsBase64;
        }
        this.addProperty(fileName.substring(0, fileName.indexOf(".")), imgAsBase64);
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)Messages.APPROVAL_NOTIFICATION_DEFAULT_SUBJECT, (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    protected MailTemplate getTemplateByOldLogic() {
        return this.getNotificationSettings().getApprovalMail();
    }

    private static Price getPrice(BaseProduct product) {
        GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
        BigDecimal fees = clientContractRelation.getCommissions().stream().map(c -> {
            if (null == c) {
                return null;
            }
            EntityReference props = c.getCommissionProperties();
            if (null == props) {
                return null;
            }
            Class type = c.getCommissionProperties().getType();
            if (FeeProperties.class.isAssignableFrom(type) || PaymentFeeProperties.class.isAssignableFrom(type)) {
                return c.getEquivalentAmount();
            }
            if (DiscountProperties.class.isAssignableFrom(type)) {
                return MiscUtil.negate((BigDecimal)c.getEquivalentAmount());
            }
            return null;
        }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal total = MiscUtil.guarded((BigDecimal)clientContractRelation.getServiceData().getTotalPrice()).add(fees);
        return Price.of(total, ApprovalNotification.convertCurrency(clientContractRelation.getGeneralData().getCurrency().getCode()));
    }

    private static String convertCurrency(String code) {
        String sc;
        String string = sc = TextUtil.nonBlank((String)code) ? code : DictHelper.getLocalCurrency();
        if ("RUB".equals(sc)) {
            return "\u20bd";
        }
        if ("EUR".equals(sc)) {
            return "\u20ac";
        }
        if ("USD".equals(sc)) {
            return "\u20024";
        }
        return sc;
    }

    public static String toCamel(String str) {
        if (null == str) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean prevNotLetter = true;
        for (char c : str.toCharArray()) {
            if (!Character.isLetter(c)) {
                if (!Character.isDigit(c)) {
                    prevNotLetter = true;
                }
                sb.append(c);
                continue;
            }
            if (prevNotLetter) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(Character.toLowerCase(c));
            }
            prevNotLetter = false;
        }
        return sb.toString();
    }

    public static String safe(String str, String def) {
        return TextUtil.nonBlank((String)str) ? str : def;
    }

    public static <T> String orSafe(Supplier<? extends T> get, Function<T, String> f, String str) {
        T t = get.get();
        if (t != null) {
            return ApprovalNotification.safe(f.apply(t), str);
        }
        return str;
    }

    public static Date wrap(Date date) {
        return date != null ? date : NULL_DATE;
    }

    public static Date unwrap(Date date) {
        return date != NULL_DATE ? date : null;
    }

    public static Double getGeoDistanceInKm(DictionaryReference<GeoLocation> geoLocRef1, Location geoLocRef2) {
        GeoLocation geoLoc1 = (GeoLocation)DictionaryCache.get().resolveReference(geoLocRef1);
        if (geoLoc1 == null) {
            return null;
        }
        if (geoLoc1.getLatitude() == 0.0 || geoLoc1.getLongitude() == 0.0) {
            return null;
        }
        if (geoLocRef2 == null) {
            return null;
        }
        if (geoLocRef2.getLatitude() == 0.0 || geoLocRef2.getLongitude() == 0.0) {
            return null;
        }
        return GeoDistanceUtil.distance((double)geoLoc1.getLatitude(), (double)geoLoc1.getLongitude(), (double)geoLocRef2.getLatitude(), (double)geoLocRef2.getLongitude(), (char)'K');
    }

    public static class Transfer {
        private final String number;
        private final String reservationUid;
        private final Date departureDateTime;
        private final Date arrivalDateTime;
        private final String startAddress;
        private final String endAddress;
        private final String startType;
        private final String endType;
        private final String classOfService;
        private final String departureCity;
        private final String arriveCity;
        private final Price price;
        private final boolean authNeeded;
        private final String description;
        public String comment;

        public Transfer(com.gridnine.xtrip.common.model.booking.transfers.Transfer product, Locale locale) {
            this.reservationUid = product.getReservation().getUid();
            this.number = product.getSystemNumber();
            this.departureCity = Transfer.getAddress(product.getStartAddress());
            this.arriveCity = Transfer.getAddress(product.getEndAddress());
            this.startAddress = product.getStartAddress();
            this.endAddress = product.getEndAddress();
            this.startType = product.getStartType().toString(locale);
            this.endType = product.getEndType().toString(locale);
            this.departureDateTime = product.getStartDate();
            this.arrivalDateTime = product.getEndDate();
            this.classOfService = ApprovalNotification.safe(product.getCarClass().toString(locale), "");
            this.price = ApprovalNotification.getPrice((BaseProduct)product);
            TravelPolicyImpositionResult travelPolicyImpositionResult = TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult((BaseProduct)product);
            this.authNeeded = TravelPolicyAuthorizationHelper.needSendToAuthorization((BaseProduct)product);
            this.description = SiteConverterHelper.getLocalizedText(Optional.ofNullable(travelPolicyImpositionResult).map(TravelPolicyImpositionResult::getL10nMessage).orElse(null));
        }

        private static String getAddress(String address) {
            return ApprovalNotification.safe(address.split(", ", 3)[1], "");
        }

        public String getNumber() {
            return this.number;
        }

        public String getReservationUid() {
            return this.reservationUid;
        }

        public Date getDepartureDateTime() {
            return this.departureDateTime;
        }

        public Date getArrivalDateTime() {
            return this.arrivalDateTime;
        }

        public String getStartAddress() {
            return this.startAddress;
        }

        public String getEndAddress() {
            return this.endAddress;
        }

        public String getStartType() {
            return this.startType;
        }

        public String getEndType() {
            return this.endType;
        }

        public String getClassOfService() {
            return this.classOfService;
        }

        public String getDepartureCity() {
            return this.departureCity;
        }

        public String getArriveCity() {
            return this.arriveCity;
        }

        public Price getPrice() {
            return this.price;
        }

        public boolean isAuthNeeded() {
            return this.authNeeded;
        }

        public String getDescription() {
            return this.description;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Transfer transfer = (Transfer)o;
            return Objects.equals(this.number, transfer.number) && Objects.equals(this.departureDateTime, transfer.departureDateTime) && Objects.equals(this.arrivalDateTime, transfer.arrivalDateTime) && Objects.equals(this.startAddress, transfer.startAddress) && Objects.equals(this.endAddress, transfer.endAddress) && Objects.equals(this.departureCity, transfer.departureCity) && Objects.equals(this.arriveCity, transfer.arriveCity) && Objects.equals(this.classOfService, transfer.classOfService) && Objects.equals(this.price, transfer.price);
        }

        public int hashCode() {
            return Objects.hash(this.number, this.departureDateTime, this.arrivalDateTime, this.departureCity, this.arriveCity, this.startAddress, this.endAddress, this.classOfService, this.price);
        }
    }

    public static class TransferGroup {
        private final String departureCity;
        private final String arrivalCity;
        private final Date date;
        private final List<Transfer> products;
        private final String reservationUid;

        public String getReservationUid() {
            return this.reservationUid;
        }

        public TransferGroup(String departureCity, String arrivalCity, Date date, List<Transfer> products, Locale locale) {
            this.departureCity = departureCity;
            this.arrivalCity = arrivalCity;
            this.date = date;
            this.products = products;
            this.reservationUid = products.get(0).getReservationUid();
        }

        public String getDepartureCity() {
            return this.departureCity;
        }

        public String getArrivalCity() {
            return this.arrivalCity;
        }

        public Date getDate() {
            return this.date;
        }

        public List<Transfer> getProducts() {
            return this.products;
        }
    }

    public static class Price {
        private final BigDecimal value;
        private final String currency;

        public Price(BigDecimal value, String currency) {
            this.value = value != null ? value : BigDecimal.ZERO;
            this.currency = ApprovalNotification.safe(currency, "");
        }

        public static Price of(BigDecimal value, String currency) {
            return new Price(value, currency);
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public String getCurrency() {
            return this.currency;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Price price = (Price)o;
            return (MiscUtil.equals((Object)this.value, (Object)price.value) || this.value != null && this.value.compareTo(price.value) == 0) && Objects.equals(this.currency, price.currency);
        }

        public int hashCode() {
            return Objects.hash(Double.hashCode(this.value.doubleValue()), this.currency);
        }
    }

    public static class DictionaryValue {
        private final String code;
        private final String name;

        public DictionaryValue(DictionaryReference<? extends BaseDictionary> ref, Locale locale) {
            String n;
            String c;
            BaseDictionary location = DictHelper.resolve(ref);
            String string = c = location != null ? DictHelper.getCodeVariant((BaseDictionary)location, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA, CodeSystem.CRT, CodeSystem.ISO}) : null;
            if (location != null && TextUtil.isBlank(c)) {
                c = location.getCode();
            }
            this.code = TextUtil.nonBlank(c) ? c : "---";
            String string2 = n = location != null ? location.toString(locale) : null;
            this.name = TextUtil.nonBlank((String)n) ? (Objects.equals(n, n.toUpperCase(locale)) ? ApprovalNotification.toCamel(n) : n) : "---";
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DictionaryValue that = (DictionaryValue)o;
            return Objects.equals(this.code, that.code);
        }

        public int hashCode() {
            return Objects.hash(this.code);
        }
    }

    public static class City
    extends DictionaryValue {
        private DictionaryValue country;

        private City(DictionaryReference<GeoLocation> ref, Locale locale) {
            super(ref, locale);
            GeoLocation location = (GeoLocation)DictHelper.resolve(ref);
            DictionaryReference countryRef = location != null ? location.getCountry() : null;
            this.country = new DictionaryValue((DictionaryReference<? extends BaseDictionary>)countryRef, locale);
        }

        public City(DictionaryReference<RailwayStation> ref, Locale locale, int dummy) {
            super(ref, locale);
            RailwayStation station = (RailwayStation)DictHelper.resolve(ref);
            DictionaryReference countryRef = station != null ? station.getCountry() : null;
            this.country = new DictionaryValue((DictionaryReference<? extends BaseDictionary>)countryRef, locale);
        }

        public static City of(DictionaryReference<GeoLocation> ref, Locale locale) {
            return new City(ref, locale);
        }

        public static City ofStation(DictionaryReference<RailwayStation> ref, Locale locale) {
            return new City(ref, locale, 0);
        }

        public DictionaryValue getCountry() {
            return this.country;
        }
    }

    public static class Airport
    extends DictionaryValue {
        private City city;

        public Airport(DictionaryReference<GeoLocation> ref, Locale locale) {
            super(ref, locale);
            DictionaryReference<GeoLocation> cityRef = DictHelper.getCity(ref);
            this.city = City.of(cityRef != null ? cityRef : ref, locale);
        }

        public static Airport of(DictionaryReference<GeoLocation> ref, Locale locale) {
            return new Airport(ref, locale);
        }

        public City getCity() {
            return this.city;
        }
    }

    public static class Station
    extends DictionaryValue {
        private final City city;

        public Station(DictionaryReference<RailwayStation> ref, Locale locale) {
            super(ref, locale);
            DictionaryReference city;
            RailwayStation station = (RailwayStation)DictHelper.resolve(ref);
            DictionaryReference dictionaryReference = city = station != null ? station.getGeoLocation() : null;
            this.city = city != null ? City.of((DictionaryReference<GeoLocation>)city, locale) : City.ofStation(station != null ? ref : null, locale);
        }

        public static Station of(DictionaryReference<RailwayStation> ref, Locale locale) {
            return ref != null ? new Station(ref, locale) : null;
        }

        public City getCity() {
            return this.city;
        }
    }

    public static class Railway {
        private final String number;
        private final Date departureDateTime;
        private final Date arrivalDateTime;
        private final String brand;
        private final String category;
        private final Period travelTime;
        private final String classOfService;
        private final List<Station> points;
        private final List<String> carriages;
        private final List<String> servicesList;
        private final List<Pair<String>> carPlaceData = new ArrayList<Pair<String>>();
        private final Price price;
        private final boolean authNeeded;
        private final String description;
        public String comment;

        public boolean isAuthNeeded() {
            return this.authNeeded;
        }

        public String getDescription() {
            return this.description;
        }

        public Railway(RailwayProduct product, Locale locale) {
            RailwaySegment segment = (RailwaySegment)product.getSegments().get(0);
            this.number = ApprovalNotification.safe(segment.getTrainNumberInSearch(), "----");
            this.departureDateTime = segment.getLocalDepartureDate();
            this.arrivalDateTime = segment.getLocalArriveDate();
            this.brand = ApprovalNotification.safe(ApprovalNotification.toCamel(segment.getBrand()), "");
            this.category = ApprovalNotification.safe(ApprovalNotification.toCamel(segment.getTrainCategory()), "");
            PlacingData placingData = ApprovalHelper.getRailIntentionPlacingData(product.getReservation());
            if (placingData != null) {
                placingData.getCarPlaceData().stream().filter(cpd -> cpd.getCarPlaceType() != null).forEach(cpd -> this.carPlaceData.add((Pair<String>)new Pair((Object)cpd.getCarPlaceType().toString(locale), (Object)String.join((CharSequence)",", cpd.getAvailableSeats()))));
            }
            RailwayServiceClass railwayServiceClass = CommonRailRestHelper.getRailwayServiceClass(segment.getServiceClass(), (DictionaryReference<RailwayCarrier>)segment.getCarrier(), segment.getTrainNumber());
            List<RailService> railServices = CommonRailRestHelper.collectRailServices(railwayServiceClass, segment.getCarrierSubcategory(), segment.getServicesList());
            this.servicesList = railServices.stream().map(rs -> rs.toString(locale)).collect(Collectors.toList());
            TravelPolicyImpositionResult travelPolicyImpositionResult = TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult((BaseProduct)product);
            this.authNeeded = TravelPolicyAuthorizationHelper.needSendToAuthorization((BaseProduct)product);
            this.description = SiteConverterHelper.getLocalizedText(Optional.ofNullable(travelPolicyImpositionResult).map(TravelPolicyImpositionResult::getL10nMessage).orElse(null));
            this.classOfService = ApprovalNotification.safe(Stream.of(segment.getCarriageType() != null ? segment.getCarriageType().toString(locale) : null, segment.getServiceClass() != null ? segment.getServiceClass().toString(locale) : null).filter(TextUtil::nonBlank).collect(Collectors.joining(", ")), "");
            this.carriages = Stream.of(segment.getCarriageNumber()).filter(TextUtil::nonBlank).collect(Collectors.toList());
            this.points = new ArrayList<Station>();
            int tt = 0;
            RailwaySegment prevSegment = null;
            for (RailwaySegment s : product.getSegments()) {
                if (null == prevSegment || !Objects.equals(prevSegment.getArriveStation(), s.getDepartureStation())) {
                    this.points.add(Station.of((DictionaryReference<RailwayStation>)s.getDepartureStation(), locale));
                }
                this.points.add(Station.of((DictionaryReference<RailwayStation>)s.getArriveStation(), locale));
                if (prevSegment != null && s.getDepartureDate() != null && prevSegment.getArriveStation() != null) {
                    tt = (int)((long)tt + TimeUnit.MILLISECONDS.toMinutes(Math.abs(s.getDepartureDate().getTime() - prevSegment.getArriveDate().getTime())));
                }
                prevSegment = s;
                if (s.getDurationInMinutes() != null) {
                    tt += s.getDurationInMinutes().intValue();
                    continue;
                }
                if (s.getArriveDate() == null || s.getDepartureDate() == null) continue;
                tt = (int)((long)tt + TimeUnit.MILLISECONDS.toMinutes(Math.abs(s.getArriveDate().getTime() - s.getDepartureDate().getTime())));
            }
            this.travelTime = Period.ofMinutes(tt);
            this.price = ApprovalNotification.getPrice((BaseProduct)product);
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getNumber() {
            return this.number;
        }

        public Date getDepartureDateTime() {
            return this.departureDateTime;
        }

        public Date getArrivalDateTime() {
            return this.arrivalDateTime;
        }

        public String getBrand() {
            return this.brand;
        }

        public String getCategory() {
            return this.category;
        }

        public Period getTravelTime() {
            return this.travelTime;
        }

        public String getClassOfService() {
            return this.classOfService;
        }

        public List<Station> getPoints() {
            return this.points;
        }

        public List<String> getCarriages() {
            return this.carriages;
        }

        public List<String> getServicesList() {
            return this.servicesList;
        }

        public List<Pair<String>> getCarPlaceData() {
            return this.carPlaceData;
        }

        public Price getPrice() {
            return this.price;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Railway railway = (Railway)o;
            return Objects.equals(this.number, railway.number) && Objects.equals(this.departureDateTime, railway.departureDateTime) && Objects.equals(this.arrivalDateTime, railway.arrivalDateTime) && Objects.equals(this.brand, railway.brand) && Objects.equals(this.category, railway.category) && Objects.equals(this.travelTime, railway.travelTime) && Objects.equals(this.classOfService, railway.classOfService) && Objects.equals(this.points, railway.points) && Objects.equals(this.carriages, railway.carriages) && Objects.equals(this.price, railway.price);
        }

        public int hashCode() {
            return Objects.hash(this.number, this.departureDateTime, this.arrivalDateTime, this.brand, this.category, this.travelTime, this.classOfService, this.points, this.carriages, this.price);
        }
    }

    public static class RailwayGroup {
        private final City departureCity;
        private final City arrivalCity;
        private final Date date;
        private final List<Railway> products;
        private final String reservationUid;

        public String getReservationUid() {
            return this.reservationUid;
        }

        public RailwayGroup(DictionaryReference<RailwayStation> departureCity, DictionaryReference<RailwayStation> arrivalCity, Date date, List<RailwayProduct> products, Locale locale) {
            this.departureCity = Station.of(departureCity, locale).getCity();
            this.arrivalCity = Station.of(arrivalCity, locale).getCity();
            this.date = date;
            this.products = products.stream().map(p -> new Railway((RailwayProduct)p, locale)).distinct().collect(Collectors.toList());
            this.reservationUid = products.get(0).getReservation().getUid();
        }

        public City getDepartureCity() {
            return this.departureCity;
        }

        public City getArrivalCity() {
            return this.arrivalCity;
        }

        public Date getDate() {
            return this.date;
        }

        public List<Railway> getProducts() {
            return this.products;
        }
    }

    public static class Period {
        private final int minutes;
        private final int hours;
        private final int days;

        public Period(int days, int hours, int minutes) {
            this.minutes = minutes;
            this.hours = hours;
            this.days = days;
        }

        public static Period ofMinutes(int minutes) {
            int v = minutes / 60;
            return new Period(v / 24, v % 24, minutes % 60);
        }

        public int getMinutes() {
            return this.minutes;
        }

        public int getHours() {
            return this.hours;
        }

        public int getDays() {
            return this.days;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Period period = (Period)o;
            return this.minutes == period.minutes && this.hours == period.hours && this.days == period.days;
        }

        public int hashCode() {
            return Objects.hash(this.minutes, this.hours, this.days);
        }
    }

    public static class AirSegment {
        private final Date departureDateTime;
        private final Date arrivalDateTime;
        private final DictionaryValue airline;
        private final DictionaryValue operatingAirline;
        private final String flightNumber;
        private final String board;
        private final Airport departureAirport;
        private final Airport arrivalAirport;
        private final String classOfService;
        private final boolean hasLuggage;

        public AirSegment(Segment segment, Product product, Locale locale) {
            this.airline = new DictionaryValue((DictionaryReference<? extends BaseDictionary>)segment.getAirline(), locale);
            this.operatingAirline = segment.isCodeShare() && segment.getCodeShareCarrier() != null ? new DictionaryValue((DictionaryReference<? extends BaseDictionary>)segment.getCodeShareCarrier(), locale) : null;
            this.flightNumber = ApprovalNotification.safe(segment.getFlightNo(), "---");
            this.board = ApprovalNotification.orSafe(() -> ((Segment)segment).getBoard(), DictionaryReference::getCaption, "---");
            this.departureDateTime = segment.getStartDate();
            this.arrivalDateTime = segment.getEndDate();
            this.departureAirport = Airport.of((DictionaryReference<GeoLocation>)segment.getDepartureLocation(), locale);
            this.arrivalAirport = Airport.of((DictionaryReference<GeoLocation>)segment.getArriveLocation(), locale);
            ClassOfService classOfService = DictHelper.findClassOfService((Segment)segment, (Date)product.getIssueDate());
            this.classOfService = classOfService != null && segment.getClassOfSvcCode() != null ? String.format("%s (%s)", classOfService.toString(locale), segment.getClassOfSvcCode()) : "";
            this.hasLuggage = segment.getLuggageInfo() != null && !segment.getLuggageInfo().isNil() || segment.getFareDetails() != null && segment.getFareDetails().getLuggageInfo() != null;
        }

        public DictionaryValue getAirline() {
            return this.airline;
        }

        public DictionaryValue getOperatingAirline() {
            return this.operatingAirline;
        }

        public String getFlightNumber() {
            return this.flightNumber;
        }

        public String getBoard() {
            return this.board;
        }

        public Date getDepartureDateTime() {
            return this.departureDateTime;
        }

        public Date getArrivalDateTime() {
            return this.arrivalDateTime;
        }

        public Airport getDepartureAirport() {
            return this.departureAirport;
        }

        public Airport getArrivalAirport() {
            return this.arrivalAirport;
        }

        public String getClassOfService() {
            return this.classOfService;
        }

        public boolean isHasLuggage() {
            return this.hasLuggage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AirSegment that = (AirSegment)o;
            return this.hasLuggage == that.hasLuggage && Objects.equals(this.airline, that.airline) && Objects.equals(this.operatingAirline, that.operatingAirline) && Objects.equals(this.flightNumber, that.flightNumber) && Objects.equals(this.board, that.board) && Objects.equals(this.departureAirport, that.departureAirport) && Objects.equals(this.arrivalAirport, that.arrivalAirport) && Objects.equals(this.departureDateTime, that.departureDateTime) && Objects.equals(this.arrivalDateTime, that.arrivalDateTime) && Objects.equals(this.classOfService, that.classOfService);
        }

        public int hashCode() {
            return Objects.hash(this.airline, this.operatingAirline, this.flightNumber, this.departureAirport, this.arrivalAirport, this.departureDateTime, this.arrivalDateTime, this.classOfService, this.hasLuggage, this.board);
        }
    }

    public static class AirWay {
        private final List<AirSegment> segments;
        private final List<Airport> points;
        private final List<DictionaryValue> operatingAirlines;
        private final int transferCount;
        private final Period travelTime;
        private Boolean refundable;
        private Boolean exchangable;
        private Money refundBefore;
        private Money exchangeBefore;
        private final boolean hasLuggage;
        private final List<String> classOfServices;
        private final Date departureDateTime;
        private final Date arrivalDateTime;
        private final Airport departureAirport;
        private final Airport arrivalAirport;
        private final Map<String, Period> transfers = new HashMap<String, Period>();

        public AirWay(List<Segment> segments, Product product, Locale locale) {
            this.segments = segments.stream().map(s -> new AirSegment((Segment)s, product, locale)).collect(Collectors.toList());
            if (this.segments.isEmpty()) {
                this.departureDateTime = null;
                this.arrivalDateTime = null;
                this.departureAirport = Airport.of(null, locale);
                this.arrivalAirport = Airport.of(null, locale);
            } else {
                AirSegment fs = this.segments.get(0);
                AirSegment as = this.segments.get(this.segments.size() - 1);
                this.departureDateTime = fs.getDepartureDateTime();
                this.arrivalDateTime = as.getArrivalDateTime();
                this.departureAirport = fs.getDepartureAirport();
                this.arrivalAirport = as.getArrivalAirport();
            }
            List ol = this.segments.stream().map(s -> s.getOperatingAirline() != null ? s.getOperatingAirline() : s.getAirline()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this.operatingAirlines = ol.size() > 1 || ol.size() == 1 && !Objects.equals(ol.get(0), new DictionaryValue((DictionaryReference<? extends BaseDictionary>)product.getCarrier(), locale)) ? ol : null;
            this.hasLuggage = this.segments.stream().anyMatch(AirSegment::isHasLuggage);
            this.classOfServices = this.segments.stream().map(AirSegment::getClassOfService).distinct().filter(TextUtil::nonBlank).collect(Collectors.toList());
            this.transferCount = segments.size() - 1;
            this.points = new ArrayList<Airport>();
            int tt = 0;
            Segment prevSegment = null;
            for (Segment s2 : segments) {
                if (null == prevSegment || !Objects.equals(prevSegment.getArriveLocation(), s2.getDepartureLocation())) {
                    this.points.add(Airport.of((DictionaryReference<GeoLocation>)s2.getDepartureLocation(), locale));
                }
                this.points.add(Airport.of((DictionaryReference<GeoLocation>)s2.getArriveLocation(), locale));
                if (prevSegment != null && s2.getStartDate() != null && prevSegment.getEndDate() != null) {
                    tt = (int)((long)tt + TimeUnit.MILLISECONDS.toMinutes(Math.abs(s2.getStartDate().getTime() - prevSegment.getEndDate().getTime())));
                }
                prevSegment = s2;
                if (s2.getFlightDuration() != null) {
                    tt += s2.getFlightDuration().intValue();
                    continue;
                }
                if (s2.getEndDate() == null || s2.getStartDate() == null) continue;
                tt = (int)((long)tt + TimeUnit.MILLISECONDS.toMinutes(Math.abs(s2.getEndDate().getTime() - s2.getStartDate().getTime())));
            }
            this.travelTime = Period.ofMinutes(tt);
            AtomicReference refundBeforeDeparture = new AtomicReference();
            AtomicReference exchangeBeforeDeparture = new AtomicReference();
            if (product.getStatus() == ProductStatus.INTENTION) {
                segments.stream().map(Segment::getPenaltiesInfo).filter(Objects::nonNull).forEach(pi -> {
                    Boolean segExchangableBeforeDeparture;
                    Boolean segRefundableBeforeDeparture = pi.getRefundableBeforeDeparture();
                    if (segRefundableBeforeDeparture != null) {
                        if (BooleanUtils.isNotTrue((Boolean)this.refundable)) {
                            this.refundable = segRefundableBeforeDeparture;
                        }
                        if (this.refundable.booleanValue() && refundBeforeDeparture.get() == null) {
                            refundBeforeDeparture.set(pi.getRefundBeforeDeparture());
                        }
                    }
                    if ((segExchangableBeforeDeparture = pi.getExchangableBeforeDeparture()) != null) {
                        if (BooleanUtils.isNotTrue((Boolean)this.exchangable)) {
                            this.exchangable = segExchangableBeforeDeparture;
                        }
                        if (this.exchangable.booleanValue() && exchangeBeforeDeparture.get() == null) {
                            exchangeBeforeDeparture.set(pi.getExchangeBeforeDeparture());
                        }
                    }
                });
                if (refundBeforeDeparture.get() != null) {
                    this.refundBefore = (Money)refundBeforeDeparture.get();
                }
                if (exchangeBeforeDeparture.get() != null) {
                    this.exchangeBefore = (Money)exchangeBeforeDeparture.get();
                }
            } else if (product.getPenaltiesInfo() != null) {
                this.refundable = product.getPenaltiesInfo().getRefundableBeforeDeparture();
                if (BooleanUtils.isTrue((Boolean)this.refundable)) {
                    this.refundBefore = product.getPenaltiesInfo().getRefundBeforeDeparture();
                }
                this.exchangable = product.getPenaltiesInfo().getExchangableBeforeDeparture();
                if (BooleanUtils.isTrue((Boolean)this.exchangable)) {
                    this.exchangeBefore = product.getPenaltiesInfo().getExchangeBeforeDeparture();
                }
            }
            for (int i = 0; i < segments.size() - 1; ++i) {
                Segment s1 = segments.get(i);
                Segment s2 = segments.get(i + 1);
                if (s1.getEndDate() == null || s2.getStartDate() == null) continue;
                Airport airport = Airport.of((DictionaryReference<GeoLocation>)s2.getDepartureLocation(), locale);
                Period period = Period.ofMinutes((int)TimeUnit.MILLISECONDS.toMinutes(Math.abs(s2.getStartDate().getTime() - s1.getEndDate().getTime())));
                this.transfers.put(airport.getCode(), period);
            }
        }

        public List<AirSegment> getSegments() {
            return this.segments;
        }

        public List<Airport> getPoints() {
            return this.points;
        }

        public List<DictionaryValue> getOperatingAirlines() {
            return this.operatingAirlines;
        }

        public int getTransferCount() {
            return this.transferCount;
        }

        public Period getTravelTime() {
            return this.travelTime;
        }

        public Boolean getRefundable() {
            return this.refundable;
        }

        public Money getRefundBefore() {
            return this.refundBefore;
        }

        public Boolean getExchangable() {
            return this.exchangable;
        }

        public Money getExchangeBefore() {
            return this.exchangeBefore;
        }

        public boolean isHasLuggage() {
            return this.hasLuggage;
        }

        public List<String> getClassOfServices() {
            return this.classOfServices;
        }

        public Date getDepartureDateTime() {
            return this.departureDateTime;
        }

        public Date getArrivalDateTime() {
            return this.arrivalDateTime;
        }

        public Airport getDepartureAirport() {
            return this.departureAirport;
        }

        public Airport getArrivalAirport() {
            return this.arrivalAirport;
        }

        public Map<String, Period> getTransfers() {
            return this.transfers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AirWay air = (AirWay)o;
            return this.refundable == air.refundable && Objects.equals(this.segments, air.segments);
        }

        public int hashCode() {
            return Objects.hash(this.segments, this.refundable);
        }
    }

    public static class Air {
        private final DictionaryValue carrier;
        private final Price price;
        private final AirWay there;
        private final AirWay back;
        private final String pnr;
        private final String mcoCategory;
        private final String reservationUid;
        private boolean authNeeded;
        private final String description;

        public Air(Product product, Locale locale) {
            this.reservationUid = product.getReservation().getUid();
            this.pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation());
            this.mcoCategory = MiscUtil.guarded((String)EnumUtil.stringValueOf((Enum)product.getMcoCategory()));
            this.carrier = new DictionaryValue((DictionaryReference<? extends BaseDictionary>)product.getCarrier(), locale);
            this.price = ApprovalNotification.getPrice((BaseProduct)product);
            TravelPolicyImpositionResult travelPolicyImpositionResult = TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult((BaseProduct)product);
            this.authNeeded = TravelPolicyAuthorizationHelper.needSendToAuthorization((BaseProduct)product);
            this.description = SiteConverterHelper.getLocalizedText(Optional.ofNullable(travelPolicyImpositionResult).map(TravelPolicyImpositionResult::getL10nMessage).orElse(null));
            if (!AirProductHelper.isRoundTrip((Product)product)) {
                this.there = new AirWay(product.getSegmentTariffs().stream().flatMap(s -> s.getSegments().stream()).collect(Collectors.toList()), product, locale);
                this.back = null;
            } else {
                ArrayList<Segment> thereSegments = new ArrayList<Segment>();
                ArrayList<Segment> backSegments = new ArrayList<Segment>();
                boolean first = true;
                boolean back = false;
                for (SegmentTariff st : product.getSegmentTariffs()) {
                    for (Segment segment : st.getSegments()) {
                        if (first) {
                            first = false;
                        } else if (segment.isStarting()) {
                            back = true;
                        }
                        if (back) {
                            backSegments.add(segment);
                            continue;
                        }
                        thereSegments.add(segment);
                    }
                }
                if (backSegments.isEmpty()) {
                    Segment segment = (Segment)thereSegments.get(thereSegments.size() - 1);
                    thereSegments.remove(segment);
                    backSegments.add(segment);
                }
                this.there = new AirWay(thereSegments, product, locale);
                this.back = new AirWay(backSegments, product, locale);
            }
        }

        public String getReservationUid() {
            return this.reservationUid;
        }

        public DictionaryValue getCarrier() {
            return this.carrier;
        }

        public Price getPrice() {
            return this.price;
        }

        public boolean isRoundTrip() {
            return this.back != null;
        }

        public boolean isAuthNeeded() {
            return this.authNeeded;
        }

        public String getDescription() {
            return this.description;
        }

        public AirWay getThere() {
            return this.there;
        }

        public AirWay getBack() {
            return this.back;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Air air = (Air)o;
            return Objects.equals(this.carrier, air.carrier) && Objects.equals(this.mcoCategory, air.mcoCategory) && Objects.equals(this.price, air.price) && Objects.equals(this.there, air.there) && Objects.equals(this.back, air.back);
        }

        public int hashCode() {
            return Objects.hash(this.carrier, this.price, this.there, this.back);
        }
    }

    public static class AirGroup {
        private final String mcoCategory;
        private final City departureCity;
        private final City arrivalCity;
        private final Date date;
        private final Date dateBack;
        private final List<AirRouteGroupProduct> routeGroups;
        private final List<Air> products;

        public List<Air> getProducts() {
            return this.products;
        }

        public AirGroup(String mcoCategory, City departureCity, City arrivalCity, Date date, Date backDate, List<Air> products) {
            this.mcoCategory = TextUtil.isBlank((String)mcoCategory) ? null : mcoCategory;
            this.departureCity = departureCity;
            this.arrivalCity = arrivalCity;
            this.products = products;
            this.date = date;
            this.dateBack = backDate;
            this.routeGroups = new ArrayList<AirRouteGroupProduct>();
            Map<String, List<Air>> collect = products.stream().collect(Collectors.groupingBy(a -> ((Air)a).pnr));
            for (Map.Entry<String, List<Air>> entry : collect.entrySet()) {
                this.routeGroups.add(new AirRouteGroupProduct(entry.getValue()));
            }
        }

        public String getMcoCategory() {
            return this.mcoCategory;
        }

        public City getDepartureCity() {
            return this.departureCity;
        }

        public City getArrivalCity() {
            return this.arrivalCity;
        }

        public Date getDate() {
            return this.date;
        }

        public Date getDateBack() {
            return this.dateBack;
        }

        public List<AirRouteGroupProduct> getRouteGroups() {
            return this.routeGroups;
        }
    }

    public static class AirRouteGroupProduct {
        private final DictionaryValue carrier;
        private final Price price;
        private final AirWay there;
        private final AirWay back;
        private final int countProduct;
        private final String reservationUid;
        private final boolean authNeeded;
        private String comment;
        private final String description;

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getDescription() {
            return this.description;
        }

        public AirRouteGroupProduct(List<Air> products) {
            Air product = products.get(0);
            this.countProduct = products.size();
            BigDecimal airGroupCost = BigDecimal.ZERO;
            String currency = product.getPrice().getCurrency();
            for (Air prod : products) {
                airGroupCost = MiscUtil.sum((BigDecimal[])new BigDecimal[]{airGroupCost, prod.price.getValue()});
            }
            this.carrier = product.getCarrier();
            this.back = product.getBack();
            this.there = product.getThere();
            this.price = new Price(airGroupCost, currency);
            this.reservationUid = products.get(0).getReservationUid();
            this.authNeeded = products.stream().anyMatch(pr -> ((Air)pr).authNeeded);
            this.description = product.getDescription();
        }

        public String getReservationUid() {
            return this.reservationUid;
        }

        public int getCountProduct() {
            return this.countProduct;
        }

        public DictionaryValue getCarrier() {
            return this.carrier;
        }

        public Price getPrice() {
            return this.price;
        }

        public boolean isRoundTrip() {
            return this.back != null;
        }

        public boolean isAuthNeeded() {
            return this.authNeeded;
        }

        public AirWay getThere() {
            return this.there;
        }

        public AirWay getBack() {
            return this.back;
        }
    }

    public static class Room {
        private final String roomName;
        private final List<String> essentialInfo;
        private final boolean withPenalty;
        private final boolean hasPenalties;
        private final boolean authNeeded;
        private final String description;
        private final String meal;
        private final Price price;
        private final Date checkInTime;
        private final Date checkOutTime;
        private final String penaltyText;
        private String comment;

        public Room(HotelProduct product, Locale locale) {
            boolean paymentInHotel;
            TravelPolicyImpositionResult travelPolicyImpositionResult = TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult((BaseProduct)product);
            this.authNeeded = TravelPolicyAuthorizationHelper.needSendToAuthorization((BaseProduct)product);
            this.description = SiteConverterHelper.getLocalizedText(Optional.ofNullable(travelPolicyImpositionResult).map(TravelPolicyImpositionResult::getL10nMessage).orElse(null));
            com.gridnine.xtrip.common.model.booking.xtriphotels.Room room = (com.gridnine.xtrip.common.model.booking.xtriphotels.Room)product.getRooms().get(0);
            this.roomName = ApprovalNotification.safe(room.getRoomName(), "-");
            this.checkInTime = room.getCheckInTime() != null ? MiscUtil.setMinutes((Date)room.getCheckInDate(), (int)room.getCheckInTime()) : null;
            this.checkOutTime = room.getCheckOutTime() != null ? MiscUtil.setMinutes((Date)room.getCheckOutDate(), (int)room.getCheckOutTime()) : null;
            this.essentialInfo = HotelProductHelper.getEssentialInfoValues((HotelProduct)product);
            boolean wp = false;
            boolean bl = paymentInHotel = product.getTicketType() == TicketType.REFERRAL;
            if (!paymentInHotel) {
                boolean canCancelWithoutPenalties;
                Date timeLimit = XtripHotelProductHelper.getTimeLimit((List)(product.isCancellable() ? product.getCancellationCharges() : Collections.emptyList()), (Date)((com.gridnine.xtrip.common.model.booking.xtriphotels.Room)product.getRooms().get(0)).getCheckInDate());
                Date now = new Date();
                boolean bl2 = canCancelWithoutPenalties = HotelsConverterHelper.canCancelWithoutPenalties(product) && (null == timeLimit || timeLimit.after(now));
                if (!canCancelWithoutPenalties) {
                    wp = true;
                }
            }
            this.withPenalty = wp;
            this.hasPenalties = !product.getCancellationCharges().isEmpty();
            List cancellationCharges = CancellationChargeHelper.normalize((Date)new Date(), (List)product.getCancellationCharges(), (LocalDate)MiscUtil.toLocalDate((Date)HotelProductHelper.getCheckInDate((HotelProduct)product)));
            Money hiddenNotRefundedFees = CancellationChargeHelper.calcHiddenNotRefundedFeesAmount((List)GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)product), (String)product.getGdsCurrency());
            this.penaltyText = CancellationChargeHelper.buildCancellationPolicy((List)cancellationCharges, (Money)HotelProductHelper.calcBasePrice((HotelProduct)product), (Money)hiddenNotRefundedFees, (String)product.getCancellationPolicyText(), (Locale)locale);
            this.meal = room.getMeal() != null ? ApprovalNotification.safe(room.getMeal().getCaption(), "") : null;
            this.price = ApprovalNotification.getPrice((BaseProduct)product);
        }

        public String getRoomName() {
            return this.roomName;
        }

        public boolean isAuthNeeded() {
            return this.authNeeded;
        }

        public String getDescription() {
            return this.description;
        }

        public Date getCheckInTime() {
            return this.checkInTime;
        }

        public Date getCheckOutTime() {
            return this.checkOutTime;
        }

        public List<String> getEssentialInfo() {
            return this.essentialInfo;
        }

        public boolean isWithPenalty() {
            return this.withPenalty;
        }

        public boolean isHasPenalties() {
            return this.hasPenalties;
        }

        public String getPenaltyText() {
            return this.penaltyText;
        }

        public String getMeal() {
            return this.meal;
        }

        public Price getPrice() {
            return this.price;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Room hotel = (Room)o;
            return this.withPenalty == hotel.withPenalty && this.hasPenalties == hotel.hasPenalties && Objects.equals(this.roomName, hotel.roomName) && Objects.equals(this.essentialInfo, hotel.essentialInfo) && Objects.equals(this.meal, hotel.meal) && Objects.equals(this.price, hotel.price);
        }

        public int hashCode() {
            return Objects.hash(this.roomName, this.essentialInfo, this.withPenalty, this.hasPenalties, this.meal, this.price);
        }
    }

    public static class Hotel {
        private final String name;
        private final String providerHotelCode;
        private final int stars;
        private final String address;
        private final String phone;
        private final Double distance;
        private final String reservationUid;
        private final List<Room> rooms = new ArrayList<Room>();

        public Hotel(HotelProduct product, Locale locale) {
            this.name = ApprovalNotification.safe(product.getHotelName(), "-");
            this.stars = MiscUtil.guarded((Integer)product.getHotelStars());
            this.providerHotelCode = product.getProviderHotelCode();
            this.address = ApprovalNotification.safe(product.getHotelAddress(), "");
            this.phone = ApprovalNotification.safe(product.getHotelPhone(), "");
            this.distance = ApprovalNotification.getGeoDistanceInKm((DictionaryReference<GeoLocation>)product.getHotelLocation(), product.getLoc());
            this.reservationUid = product.getReservation().getUid();
            this.rooms.add(new Room(product, locale));
        }

        public String getName() {
            return this.name;
        }

        public String getProviderHotelCode() {
            return this.providerHotelCode;
        }

        public int getStars() {
            return this.stars;
        }

        public String getAddress() {
            return this.address;
        }

        public String getPhone() {
            return this.phone;
        }

        public Double getDistance() {
            return this.distance;
        }

        public String getReservationUid() {
            return this.reservationUid;
        }

        public List<Room> getRooms() {
            return this.rooms;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hotel hotel = (Hotel)o;
            return Objects.equals(this.name, hotel.name) && Objects.equals(this.providerHotelCode, hotel.providerHotelCode);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.providerHotelCode);
        }
    }

    public static class HotelGroup {
        private final City city;
        private final Date checkInDate;
        private final Date checkOutDate;
        private final List<Hotel> products = new ArrayList<Hotel>();

        public HotelGroup(DictionaryReference<GeoLocation> cityRef, Date checkInDate, Date checkOutDate, List<HotelProduct> products, Locale locale) {
            this.city = City.of(cityRef, locale);
            this.checkInDate = checkInDate;
            this.checkOutDate = checkOutDate;
            products.forEach(product -> {
                Hotel hotel = this.getProductHotel((HotelProduct)product);
                if (Objects.nonNull(hotel)) {
                    hotel.getRooms().add(new Room((HotelProduct)product, locale));
                } else {
                    this.products.add(new Hotel((HotelProduct)product, locale));
                }
            });
        }

        private Hotel getProductHotel(HotelProduct hp) {
            return this.products.stream().filter(product -> product.getProviderHotelCode().equals(hp.getProviderHotelCode())).findFirst().orElse(null);
        }

        public City getCity() {
            return this.city;
        }

        public Date getCheckOutDate() {
            return this.checkOutDate;
        }

        public Date getCheckInDate() {
            return this.checkInDate;
        }

        public List<Hotel> getProducts() {
            return this.products;
        }
    }

    public static class Traveller {
        private final String name;

        public Traveller(com.gridnine.xtrip.common.model.booking.Traveller traveller) {
            this.name = traveller.getName();
        }

        public Traveller(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Traveller traveller = (Traveller)o;
            return Objects.equals(this.name, traveller.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static class DataModel {
        private final List<Traveller> travellers;
        private final List<HotelGroup> hotelGroups = new ArrayList<HotelGroup>();
        private final List<AirGroup> airGroups = new ArrayList<AirGroup>();
        private final List<RailwayGroup> railwayGroups = new ArrayList<RailwayGroup>();
        private final List<TransferGroup> transferGroups = new ArrayList<TransferGroup>();
        private String refuseLink;
        private String authLink;

        public DataModel(BookingFile bookingFile, List<String> productsToApprove, Locale locale, MailCommentFindFunction<String, Integer> function) {
            List baseProducts = bookingFile.getReservations().stream().map(Reservation::getProducts).flatMap(Collection::stream).filter(p -> CollectionUtil.isEmpty((Collection)productsToApprove) && p.getReservation().getStatus() != ReservationStatus.CANCELED || productsToApprove.contains(p.getUid())).collect(Collectors.toList());
            List reservationTravellers = baseProducts.stream().map(GeneralProductHelper::getTravellers).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            this.travellers = reservationTravellers.stream().filter(t -> TextUtil.nonBlank((String)t.getName())).map(Traveller::new).distinct().collect(Collectors.toList());
            long uc = reservationTravellers.stream().filter(t -> TextUtil.isBlank((String)t.getName())).count();
            if (uc > 0L) {
                String name = String.format("%1$d \u0447\u0435\u043b\u043e\u0432\u0435\u043a%2$s", uc, uc == 1L ? "\u0430" : "");
                this.travellers.add(new Traveller(name));
            }
            baseProducts.stream().filter(p -> p instanceof HotelProduct).map(HotelProduct.class::cast).collect(Collectors.groupingBy(p -> MiscUtil.Pair.of((Object)ApprovalNotification.wrap(MiscUtil.clearTime((Date)((com.gridnine.xtrip.common.model.booking.xtriphotels.Room)p.getRooms().get(0)).getCheckInDate())), (Object)ApprovalNotification.wrap(MiscUtil.clearTime((Date)((com.gridnine.xtrip.common.model.booking.xtriphotels.Room)p.getRooms().get(0)).getCheckOutDate()))), Collectors.groupingBy(HotelProduct::getHotelLocation))).forEach((datePair, v) -> v.forEach((city, products) -> this.hotelGroups.add(new HotelGroup((DictionaryReference<GeoLocation>)city, ApprovalNotification.unwrap((Date)datePair.getFirst()), ApprovalNotification.unwrap((Date)datePair.getSecond()), (List<HotelProduct>)products, locale))));
            baseProducts.stream().filter(p -> p instanceof Product).map(Product.class::cast).filter(p -> p.getNextProduct() == null).map(p -> new Air((Product)p, locale)).collect(Collectors.groupingBy(a -> ((Air)a).mcoCategory, Collectors.groupingBy(a -> ApprovalNotification.wrap(MiscUtil.clearTime((Date)a.getThere().getDepartureDateTime())), Collectors.groupingBy(a -> ApprovalNotification.wrap(a.getBack() != null ? MiscUtil.clearTime((Date)a.getBack().getDepartureDateTime()) : null), Collectors.groupingBy(a -> a.getThere().getDepartureAirport().getCity(), Collectors.groupingBy(a -> a.getThere().getArrivalAirport().getCity())))))).forEach((mcoCategory, v0) -> v0.forEach((date, v1) -> v1.forEach((dateBack, v2) -> v2.forEach((departure, v3) -> v3.forEach((arrival, products) -> this.airGroups.add(new AirGroup((String)mcoCategory, (City)departure, (City)arrival, ApprovalNotification.unwrap(date), ApprovalNotification.unwrap(dateBack), (List<Air>)products)))))));
            baseProducts.stream().filter(p -> p instanceof RailwayProduct).map(RailwayProduct.class::cast).collect(Collectors.groupingBy(p -> ApprovalNotification.wrap(MiscUtil.clearTime((Date)RailwayProductHelper.getFirstLocalDepartureDate((RailwayProduct)p))), Collectors.groupingBy(p -> {
                RailwaySegment s = !p.getSegments().isEmpty() ? (RailwaySegment)p.getSegments().get(0) : null;
                return s != null ? RailwayHelper.getCityStation((DictionaryReference<RailwayStation>)s.getDepartureStation()) : null;
            }, Collectors.groupingBy(p -> {
                RailwaySegment s = !p.getSegments().isEmpty() ? (RailwaySegment)p.getSegments().get(p.getSegments().size() - 1) : null;
                return s != null ? RailwayHelper.getCityStation((DictionaryReference<RailwayStation>)s.getArriveStation()) : null;
            })))).forEach((date, v) -> v.forEach((departure, v2) -> v2.forEach((arrival, products) -> this.railwayGroups.add(new RailwayGroup((DictionaryReference<RailwayStation>)departure, (DictionaryReference<RailwayStation>)arrival, ApprovalNotification.unwrap(date), (List<RailwayProduct>)products, locale)))));
            baseProducts.stream().filter(com.gridnine.xtrip.common.model.booking.transfers.Transfer.class::isInstance).map(com.gridnine.xtrip.common.model.booking.transfers.Transfer.class::cast).map(p -> new Transfer((com.gridnine.xtrip.common.model.booking.transfers.Transfer)p, locale)).collect(Collectors.groupingBy(a -> ApprovalNotification.wrap(MiscUtil.clearTime((Date)a.getDepartureDateTime())), Collectors.groupingBy(Transfer::getDepartureCity, Collectors.groupingBy(Transfer::getArriveCity)))).forEach((date, v1) -> v1.forEach((departure, v2) -> v2.forEach((arrival, products) -> this.transferGroups.add(new TransferGroup((String)departure, (String)arrival, ApprovalNotification.unwrap(date), (List<Transfer>)products, locale)))));
            if (function == null) {
                return;
            }
            AtomicInteger counter1 = new AtomicInteger(-1);
            this.railwayGroups.forEach(railwayGroup -> railwayGroup.getProducts().stream().peek(railway -> counter1.incrementAndGet()).findFirst().ifPresent(mailProduct -> mailProduct.setComment(function.getComment(railwayGroup.getReservationUid(), counter1.get()))));
            AtomicInteger counter2 = new AtomicInteger(-1);
            this.hotelGroups.forEach(hotelGroup -> hotelGroup.getProducts().forEach(product -> product.getRooms().stream().peek(hotel -> counter2.incrementAndGet()).forEach(mailProduct -> mailProduct.setComment(function.getComment(product.getReservationUid(), counter2.get())))));
            AtomicInteger counter3 = new AtomicInteger(-1);
            this.airGroups.forEach(airGroup -> airGroup.getRouteGroups().stream().peek(mailProduct -> counter3.incrementAndGet()).forEach(mailProduct -> mailProduct.setComment(function.getComment(mailProduct.getReservationUid(), counter3.get()))));
            AtomicInteger counter4 = new AtomicInteger(-1);
            this.transferGroups.forEach(transferGroup -> transferGroup.getProducts().stream().peek(railway -> counter4.incrementAndGet()).findFirst().ifPresent(mailProduct -> mailProduct.setComment(function.getComment(transferGroup.getReservationUid(), counter4.get()))));
        }

        public void setRefuseLink(String refuseLink) {
            this.refuseLink = refuseLink;
        }

        public void setAuthLink(String authLink) {
            this.authLink = authLink;
        }

        public List<Traveller> getTravellers() {
            return this.travellers;
        }

        public List<HotelGroup> getHotelGroups() {
            return this.hotelGroups;
        }

        public List<AirGroup> getAirGroups() {
            return this.airGroups;
        }

        public List<RailwayGroup> getRailwayGroups() {
            return this.railwayGroups;
        }

        public List<TransferGroup> getTransferGroups() {
            return this.transferGroups;
        }

        public String getAuthLink() {
            return this.authLink;
        }

        public String getRefuseLink() {
            return this.refuseLink;
        }
    }
}

