/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.railway;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationIntentionData;
import com.gridnine.xtrip.common.model.booking.ReservationRailIntentionData;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.IBusIbeCorpContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class RailwayApprovalUpdateReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdReservationCreationParameters creationParameters = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        RzdBookingSegmentParams segmentParams = (RzdBookingSegmentParams)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_BOOKING_SEGMENT_PARAMS);
        if (segmentParams == null) {
            segmentParams = creationParameters.getSegment();
        }
        String number = SequenceNumberHelper.generateNumber((String)"approval-reservation", RailwayProductIndex.class, SearchQueryHelper::getRecordLocatorSearchCriterionForRailwayProductIndex, (String)"AR", null);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.IBE, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)number);
        ReservationGdsNameInfoHelper.setRulesGdsNameFromAccount((Reservation)reservation, (EntityContainer)accountCtr);
        reservation.setType(ReservationType.IBE);
        if (null == reservation.getTimeLimit()) {
            reservation.setTimeLimit((Date)reservation.getProducts().stream().map(RailwayProduct.class::cast).flatMap(p -> p.getSegments().stream()).map(RailwaySegment::getDepartureDate).min(Date::compareTo).orElse(null));
        }
        ReservationIntentionData intentionData = new ReservationIntentionData();
        intentionData.setRailData(new ReservationRailIntentionData());
        intentionData.getRailData().setPlacingRequirements((BaseEntity)segmentParams.getPlacing());
        intentionData.getRailData().setPlacingData((BaseEntity)segmentParams.getPlacingData());
        reservation.setIntentionData(intentionData);
        reservation.getProducts().forEach(p -> GeneralProductHelper.getHandler((BaseProduct)p).setStatus(p, ProductStatus.INTENTION));
        Boolean isProposal = (Boolean)ctx.getObject((Enum)IBusIbeCorpContextKeys.IS_PROPOSAL);
        reservation.setProposal(Boolean.TRUE.equals(isProposal));
    }
}

