/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.railway.selectIntention;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsResult;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;

public class ApprovalCheckTrainSeatsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RzdGetTrainSeatsResult trainSeats = (RzdGetTrainSeatsResult)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_RESULT);
        Boolean isAutoTicketing = (Boolean)ctx.getObject((Enum)IBusTravelPolicyContextKeys.IS_TICKETING_AFTER_AUTHORIZATION_APPROVAL);
        if (BooleanUtils.isNotTrue((Boolean)isAutoTicketing)) {
            return;
        }
        String carriageNumber = ApprovalHelper.getRailIntentionCarNumber(reservation);
        PlacingRequirements plReq = ApprovalHelper.getRailIntentionPlacingRequirements(reservation);
        Integer seatRangeFirst = plReq.getSeatRangeFirst();
        Integer seatRangeLast = plReq.getSeatRangeLast();
        long availableSeatsCount = trainSeats.getPrices().stream().map(RzdPrice::getCars).flatMap(Collection::stream).filter(rzdCar -> MiscUtil.equals((Object)carriageNumber, (Object)rzdCar.getNumber())).map(RzdCar::getVacantSeats).flatMap(Collection::stream).filter(TextUtil::nonBlank).map(RzdCommonHelper::seat2IntValue).filter(Objects::nonNull).filter(nmb -> MiscUtil.isBetween((Number)seatRangeFirst, (Number)seatRangeLast, (Number)nmb)).count();
        long needSeatsCount = BookingStreamHelper.getProductsStream((Reservation)reservation, RailwayProduct.class).map(RailwayProduct::getPassengerTypes).flatMap(Collection::stream).filter(pt -> !DictHelper.isInfantPassengerType((DictionaryReference)pt.getPassengerType())).count();
        if (needSeatsCount > availableSeatsCount) {
            throw Xeption.forEndUser((String)Messages.TRAIN_NOT_FOUND, (Object[])new Object[0]);
        }
    }
}

