/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.railway.selectIntention;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.railway.IBusRailApprovalContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ApprovalSearchTrainSeatsParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        RailwaySegment segment = (RailwaySegment)ctx.getMandatoryObject((Enum)IBusRailApprovalContextKeys.APPROVAL_RAIL_SEGMENT);
        RzdTrainWithCategories train = (RzdTrainWithCategories)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.GDS_TRAIN);
        List categories = train.getCategories().stream().filter(this.filterRzdCategories(train, segment)).collect(Collectors.toList());
        if (categories.size() != 1) {
            String errorMessage = String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0432\u0430\u0433\u043e\u043d\u0430 %s (%s) \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u0430 %s.", segment.getCarriageType(), segment.getServiceClass(), train.getTrain().getDisplayNumber());
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)errorMessage, (Object[])new Object[0]));
            throw Xeption.forEndUser((String)errorMessage, (Object[])new Object[0]);
        }
        RzdGetTrainSeatsParameters parameters = this.buildGetTrainSeatsParameters(segment);
        parameters.setTrainProvider(train.getTrain().getTrainProvider());
        parameters.setGdsAccount(train.getTrain().getGdsAccount());
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_PARAMETERS, (Object)parameters);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN, (Object)train.getTrain());
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_CATEGORY, CollectionUtil.head(categories));
    }

    private RzdGetTrainSeatsParameters buildGetTrainSeatsParameters(RailwaySegment segment) {
        RzdGetTrainSeatsParameters parameters = new RzdGetTrainSeatsParameters();
        parameters.setDeparture(segment.getDepartureStation());
        parameters.setArrival(segment.getArriveStation());
        parameters.setDepartureDate(segment.getDepartureDate());
        parameters.setTrainNumber(segment.getTrainNumberOriginal());
        parameters.setCarriageType(segment.getCarriageType());
        return parameters;
    }

    private Predicate<RzdCategory> filterRzdCategories(RzdTrainWithCategories train, RailwaySegment segment) {
        return train.getTrain().isGroupedByServiceClass() ? cat -> cat.getServiceClasses().contains(segment.getServiceClass()) : cat -> cat.getCarriageType() == segment.getCarriageType();
    }
}

