/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.railway.selectIntention;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.railway.IBusRailApprovalContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class ApprovalSearchTrainsParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailwaySegment segment = (RailwaySegment)ctx.getMandatoryObject((Enum)IBusRailApprovalContextKeys.APPROVAL_RAIL_SEGMENT);
        TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
        travelPolicyParams.setClientRef(reservation.getBookingFile().getCustomerProfile());
        travelPolicyParams.getPersons().addAll(ApprovalSearchTrainsParametersConverter.collectPassengers(reservation));
        ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_PARAMETERS, (Object)this.buildSearchTrainsParameters(segment));
        ctx.putObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS, ApprovalHelper.getSelectedPassengers(reservation));
    }

    private static Collection<EntityReference<Person>> collectPassengers(Reservation reservation) {
        return RailwayProductHelper.getRailwayProductStream((Reservation)reservation).map(RailwayProduct::getPassengers).flatMap(Collection::stream).map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private RzdSearchTrainsParameters buildSearchTrainsParameters(RailwaySegment segment) {
        RzdSearchTrainsParameters parameters = new RzdSearchTrainsParameters();
        parameters.setDeparture(segment.getDepartureStation());
        parameters.setArrival(segment.getArriveStation());
        parameters.setDepartureDate(segment.getLocalDepartureDate());
        parameters.setTimeTo(Integer.valueOf(24));
        parameters.setTimeFrom(Integer.valueOf(0));
        return parameters;
    }
}

