/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.railway.selectIntention;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsResult;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.railway.IBusRailApprovalContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.RailSelectIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.RailSelectIntentionPreferences;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SelectIntentionResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatAmount;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatRange;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatsRequest;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Train;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.RestRailCarriagesHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.RestRailHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;

public class ApprovalSelectIntentionResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailwaySegment segment = (RailwaySegment)ctx.getMandatoryObject((Enum)IBusRailApprovalContextKeys.APPROVAL_RAIL_SEGMENT);
        Train restTrain = (Train)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.REST_TRAIN);
        RzdTrainWithCategories rzdTrain = (RzdTrainWithCategories)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.GDS_TRAIN);
        RzdCategory rzdCategory = (RzdCategory)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_CATEGORY);
        RzdGetTrainSeatsResult trainSeats = (RzdGetTrainSeatsResult)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_RESULT);
        SelectIntentionResult result = (SelectIntentionResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        List passengers = (List)ctx.getObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS);
        RailSelectIntentionData intentionData = new RailSelectIntentionData();
        intentionData.setTrain(restTrain);
        intentionData.setClientPreferences(ApprovalSelectIntentionResultConverter.buildSelectIntentionPreferences(segment, reservation));
        Gender filteringGender = RestRailCarriagesHelper.getFilteringGender(passengers);
        intentionData.getCarriages().addAll(RestRailCarriagesHelper.convertCarriages2Rest(restTrain, rzdTrain.getTrain(), trainSeats.getPrices(), rzdCategory.getUid(), filteringGender));
        intentionData.getSpecialServiceClasses().addAll(RestRailHelper.buildSpecialServiceClasses());
        result.setOldPrice(BookingHelper.getTotalPrice((Reservation)reservation, (ContractType)ContractType.CLIENT));
        ctx.putObject((Enum)IBusRailwayContextKeys.INTENTION_OLD_RESERVATION, (Object)reservation);
        result.setRailData(intentionData);
    }

    private static RailSelectIntentionPreferences buildSelectIntentionPreferences(RailwaySegment segment, Reservation reservation) {
        RailSelectIntentionPreferences clientPreferences = new RailSelectIntentionPreferences();
        clientPreferences.setCarriageNumber(segment.getCarriageNumber());
        PlacingRequirements req = ApprovalHelper.getRailIntentionPlacingRequirements(reservation);
        if (req != null) {
            SeatsRequest request = new SeatsRequest();
            request.setKupeIndication(req.getKupeIndication());
            request.setOneKupeAllSeats(req.isOneKupeAllSeats());
            request.setSeatsAmount(req.getSeatsAmount());
            request.setFullCompartment(req.isFullCompartment());
            request.setGender(CommonRailRestHelper.getGender(req.getGender()));
            request.setWithBed(BooleanUtil.nullAsFalse((Boolean)req.getWithBedding()));
            SeatAmount seatAmount = new SeatAmount();
            seatAmount.setLower(req.getLowerSeatsCount());
            seatAmount.setUpper(req.getUpperSeatsCount());
            request.setAmount(seatAmount);
            SeatRange seatRange = new SeatRange();
            seatRange.setFirst(req.getSeatRangeFirst());
            seatRange.setSecond(req.getSeatRangeLast());
            request.setRange(seatRange);
            clientPreferences.setSeatsRequest(request);
        }
        return clientPreferences;
    }
}

