/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.railway.selectIntention;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Train;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;

public class ApprovalSelectIntentionRzdTrainConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RzdTrainWithCategories rzdTrain = (RzdTrainWithCategories)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.GDS_TRAIN);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        RzdSearchTrainsParameters gdsParams = (RzdSearchTrainsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_PARAMETERS);
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        ArrayList<EntityReference<Person>> passengers = new ArrayList<EntityReference<Person>>();
        HashMap<DictionaryReference<PassengerType>, Integer> passengersTypesMap = new HashMap<DictionaryReference<PassengerType>, Integer>();
        RailwayProductHelper.getRailwayProductStream((Reservation)reservation).forEach(railProduct -> {
            railProduct.getPassengers().stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(passengers::add);
            RailwayProductHelper.getPassengerTypes((RailwayProduct)railProduct).forEach(type -> passengersTypesMap.compute((DictionaryReference<PassengerType>)type, (typeKey, count) -> count != null ? count + 1 : 1));
        });
        Train restTrain = new Train();
        CommonRailRestHelper.convertRzdTrainToRest(rzdTrain, restTrain, (EntityReference<Organization>)salesContext.getClient(), passengers, passengersTypesMap, null, gdsParams, siteType, generalSettings);
        ctx.putObject((Enum)IBusIbecorpRailContextKeys.REST_TRAIN, (Object)restTrain);
    }
}

