/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.transfers;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.transfers.Subaddress;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SelectIntentionResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.TransferSelectIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.RestTransfersHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.SearchResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ApprovalFindReservationTransferProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List responses = (List)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_RESPONSE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SelectIntentionResult result = (SelectIntentionResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        PriceComponentsParameters priceComponentsParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), salesContext);
        Transfer transfer = (Transfer)reservation.getProducts().get(0);
        SearchResponse response = responses.stream().filter(resp -> this.sameTransfer(transfer, resp.getTo())).findFirst().orElse(null);
        if (response == null) {
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0422\u0440\u0430\u043d\u0441\u0444\u0435\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", (Object[])new Object[0]));
            throw Xeption.forEndUser((String)"\u0422\u0440\u0430\u043d\u0441\u0444\u0435\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", (Object[])new Object[0]);
        }
        TransferSelectIntentionData intentionData = new TransferSelectIntentionData();
        result.setTransferData(intentionData);
        List<EntityReference<Person>> passengers = transfer.getTravellers().stream().map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<Subaddress> subAddresses = new ArrayList<Subaddress>();
        for (int i = 0; i < transfer.getSubAddresses().size(); ++i) {
            subAddresses.add(RestTransfersHelper.buildAddress((String)transfer.getSubAddresses().get(i), (String)transfer.getSubAddressesLocations().get(i)));
        }
        intentionData.setTransfer(RestTransfersHelper.convertToRestTransfer(response, (EntityReference<Organization>)salesContext.getClient(), passengers, null, RestTransfersHelper.buildAddress(transfer.getStartAddress(), transfer.getStartPlaceLocation()), RestTransfersHelper.buildAddress(transfer.getEndAddress(), transfer.getEndPlaceLocation()), subAddresses, transfer.getStartDate(), null, RestTransfersHelper.getDuration(transfer), null, priceComponentsParameters));
        result.setOldPrice(BookingHelper.getTotalPrice((Reservation)reservation, (ContractType)ContractType.CLIENT));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private boolean sameTransfer(Transfer transfer, SearchGdsResponse gdsResponse) {
        return gdsResponse.getCarClass().getCarClassDict().equals((Object)transfer.getCarClass());
    }
}

