/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.transfers;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.RestTransfersHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.SearchRequest;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.util.Date;

public class ApprovalSearchTransfersParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_REQUEST, (Object)this.buildTransfersSearchParameters(reservation));
        ctx.putObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS, ApprovalHelper.getSelectedPassengers(reservation));
    }

    private SearchRequest buildTransfersSearchParameters(Reservation reservation) {
        SearchRequest request = new SearchRequest();
        Transfer transfer = (Transfer)reservation.getProducts().get(0);
        request.setStartPlaceCoordinates(transfer.getStartPlaceLocation());
        if (transfer.getTransferType() == TransferType.TRANSFER) {
            request.setEndPlaceCoordinates(transfer.getEndPlaceLocation());
        } else {
            request.setDuration(RestTransfersHelper.getDuration(transfer));
        }
        request.setStartDate(MiscUtil.toLocalDateTime((Date)transfer.getStartDate()));
        request.setRoundTrip(false);
        request.setTransferType(transfer.getTransferType());
        request.setAdultCount(transfer.getAdultCount());
        request.setChildCount(transfer.getChildCount());
        return request;
    }
}

