/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.authorization.login;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.SecurityType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.assets.UserSecurityTokenAsset;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.B2BLoginParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.login.LoginProcessor;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.LoginParameters;
import com.gridnine.xtrip.server.ibecorp.helpers.UserSecurityHelper;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeoutException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;

public class B2BLoginProcessor
extends LoginProcessor {
    @Override
    protected boolean isAuthenticatedUser(EntityContainer<Person> personCtr, LoginParameters parameters) throws Exception {
        Person person = (Person)personCtr.getEntity();
        if (person.getSecurityType() == SecurityType.GOOGLE) {
            B2BLoginParameters params = (B2BLoginParameters)parameters;
            String code = params.getCode();
            if (TextUtil.isBlank((String)code)) {
                params.getValidationContext().getCodeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
                throw new ValidationException();
            }
            if (!this.checkGoogle(personCtr, code)) {
                params.getValidationContext().getCodeValidationMessages().add(StandardValidationMessages.getWrongValue());
                throw new ValidationException();
            }
        }
        return AuthorizationHelper.isValidB2BPersonTypes(person);
    }

    private boolean checkGoogle(EntityContainer<Person> personCtr, String code) throws TimeoutException, InterruptedException {
        String newGoogleAuthToken;
        UserSecurityTokenAsset userSecurityTokenAsset = UserSecurityHelper.findUserSecurityTokenAsset(personCtr.getUid());
        String googleAuthToken = UserSecurityHelper.getGoogleAuthToken(userSecurityTokenAsset);
        try {
            String[] values = googleAuthToken.split("\n");
            String secretKey = values[0];
            long counter = values.length == 1 ? 0L : Long.parseLong(values[1]);
            long newCounter = this.validateValue(secretKey, counter, code) + 1L;
            if (0L == newCounter) {
                return false;
            }
            newGoogleAuthToken = secretKey + "\n" + newCounter;
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
            throw Xeption.forAdmin((String)"invalid google auth", (Object[])new Object[0]);
        }
        LockUtil.lock(personCtr, () -> {
            UserSecurityTokenAsset newUserSecurityTokenAsset = UserSecurityHelper.findOrCreateUserSecurityTokenAsset(personCtr.getUid());
            UserSecurityHelper.setGoogleAuthToken(newUserSecurityTokenAsset, newGoogleAuthToken);
            AssetsStorage.get().save((BaseAsset)newUserSecurityTokenAsset);
            SysLogHelper.audit((EntityReference)personCtr.toReference(), (String)"update-user-security-asset", (Message[])new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"google auth", (Object[])new Object[0])});
        });
        return true;
    }

    private long validateValue(String secretKey, long counter, String enteredOtpValue) {
        try {
            Base32 base32 = new Base32();
            byte[] decodedSecretKey = base32.decode(secretKey);
            int CODE_DIGITS_NUMBER = 6;
            int WINDOW_RANGE = 10;
            long newCounter = -1L;
            for (int i = 0; i < 10; ++i) {
                long x = counter + (long)i;
                String generateOTP = this.generateOTP(decodedSecretKey, x, 6);
                if (!generateOTP.equals(enteredOtpValue)) continue;
                newCounter = x;
                break;
            }
            return newCounter;
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            throw new RuntimeException("incorrect otp value");
        }
    }

    private byte[] hmac_sha1(byte[] keyBytes, byte[] text) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmacSha1;
        try {
            hmacSha1 = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            hmacSha1 = Mac.getInstance("HMAC-SHA-1");
        }
        SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
        hmacSha1.init(macKey);
        return hmacSha1.doFinal(text);
    }

    private String generateOTP(byte[] secret, long movingFactor, int codeDigits) throws NoSuchAlgorithmException, InvalidKeyException {
        StringBuilder result = new StringBuilder();
        byte[] text = new byte[8];
        for (int i = text.length - 1; i >= 0; --i) {
            text[i] = (byte)(movingFactor & 0xFFL);
            movingFactor >>= 8;
        }
        byte[] hash = this.hmac_sha1(secret, text);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = (int)((double)binary % Math.pow(10.0, codeDigits));
        result.append(otp);
        while (result.length() < codeDigits) {
            result.insert(0, "0");
        }
        return result.toString();
    }
}

