/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.authorization.login;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.authorization.login.B2BAuthConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.AgencySalesPoints;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.B2BLoginResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.SelectablePreferences;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class B2BLoginResultSelectablePreferencesConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Set personTypes;
        B2BLoginResult result = new B2BLoginResult();
        EntityReference userRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        result.setSelectablePreferences(new SelectablePreferences());
        Person user = (Person)EntityStorage.get().resolve(userRef).getEntity();
        List<PersonEmployment> validEmployments = AuthorizationHelper.getValidEmployments(user);
        Set validEmpOrgUids = validEmployments.stream().map(PersonEmployment::getOrganization).filter(Objects::nonNull).map(EntityReference::getUid).collect(Collectors.toSet());
        if (validEmpOrgUids.isEmpty()) {
            throw Xeption.forAdmin((String)"\u041c\u0435\u0441\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.", (Object[])new Object[0]);
        }
        if (validEmpOrgUids.size() > 1) {
            SearchQuery query = new SearchQuery();
            query.getPreferredProperties().add(OrganizationIndex.Property.shortName.name());
            query.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])validEmpOrgUids.toArray()));
            List data = EntityStorage.get().search(OrganizationIndex.class, query).getData();
            data.stream().map(B2BAuthConverterHelper::convertOrganizationIndex2RestEmployer).forEach(restEmpl -> result.getSelectablePreferences().getEmployers().add(restEmpl));
        }
        if ((personTypes = user.getTypes().stream().filter(AuthorizationHelper.VALID_B2B_TYPES_CRITERION).collect(Collectors.toSet())).size() > 1) {
            result.getSelectablePreferences().getPersonTypes().addAll(personTypes);
        }
        Map salesPointsMap = result.getSelectablePreferences().getAgencySalesPoints();
        B2BRestHelper.buildOrgSalesPlacesMap(user).forEach((agency, pairs) -> {
            if (!validEmpOrgUids.contains(agency.getUid())) {
                return;
            }
            AgencySalesPoints salesPoints = new AgencySalesPoints();
            pairs.forEach(pair -> {
                PlaceOfSales pos = (PlaceOfSales)pair.getFirst();
                EntityReference spRef = (EntityReference)pair.getSecond();
                salesPoints.getSalesPoints().add(spRef);
                if (pos.isDefaultForOrg()) {
                    salesPoints.setDefaultSalesPoint(spRef);
                }
            });
            salesPointsMap.put(agency.getUid(), salesPoints);
        });
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

