/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.authorization.login;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.ibecorp.assets.SiteUserPreferences;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.SelectPreferencesParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Objects;

public class SaveSiteUserPreferencesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        SelectPreferencesParameters params = (SelectPreferencesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer loginAgentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER);
        SiteUserPreferences userPreferences = this.getSiteUserPreferences(((Person)loginAgentCtr.getEntity()).getLoginName());
        userPreferences.setOrganizationReferenceUid(Objects.nonNull(params.getEmployer()) ? params.getEmployer().getUid() : null);
        userPreferences.setOrganizationReferenceCaption(Objects.nonNull(params.getEmployer()) ? params.getEmployer().getCaption() : null);
        userPreferences.setPersonType(params.getPersonType());
        userPreferences.setSalesPointReferenceCaption(Objects.nonNull(params.getDefaultSalesPoint()) ? params.getDefaultSalesPoint().getCaption() : null);
        userPreferences.setSalesPointReferenceUid(Objects.nonNull(params.getDefaultSalesPoint()) ? params.getDefaultSalesPoint().getUid() : null);
        AssetsStorage.get().save((BaseAsset)userPreferences);
    }

    private SiteUserPreferences getSiteUserPreferences(String loginName) {
        SiteUserPreferences userPreferences = (SiteUserPreferences)AssetsStorage.get().find(SiteUserPreferences.class, "loginName", (Object)loginName);
        if (userPreferences == null) {
            userPreferences = new SiteUserPreferences();
            userPreferences.setLoginName(loginName);
        }
        return userPreferences;
    }
}

