/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.authorization.login;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rest.AuthUserPreferencesToken;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;

public class SelectUserPreferencesProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        List<MiscUtil.Pair<PlaceOfSales, EntityReference<SalesPoint>>> spList;
        RestContext context = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
        EntityReference userRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        Person user = (Person)EntityStorage.get().resolve(userRef).getEntity();
        Set personTypes = user.getTypes().stream().filter(AuthorizationHelper.VALID_B2B_TYPES_CRITERION).collect(Collectors.toSet());
        Cookie authTokenCookie = new Cookie("IBECORP_B2B_USER_PREFERENCES_TOKEN_COOKIE", "");
        authTokenCookie.setPath("/");
        authTokenCookie.setMaxAge(-1);
        if (personTypes.size() > 1) {
            context.getResponse().addCookie(authTokenCookie);
            return "true";
        }
        List<PersonEmployment> employments = AuthorizationHelper.getValidEmployments(user);
        EntityReference userOrgRef = null;
        if (employments.size() > 1) {
            context.getResponse().addCookie(authTokenCookie);
            return "true";
        }
        if (employments.size() == 1 && employments.get(0).getOrganization() != null) {
            userOrgRef = employments.get(0).getOrganization();
        }
        if ((spList = B2BRestHelper.buildOrgSalesPlacesMap(user).get(userOrgRef)) != null && spList.size() > 1) {
            context.getResponse().addCookie(authTokenCookie);
            return "true";
        }
        EntityReference salesPointRef = CollectionUtil.isNotEmpty(spList) ? (EntityReference)spList.get(0).getSecond() : null;
        authTokenCookie.setValue(new AuthUserPreferencesToken((PersonType)personTypes.iterator().next(), userOrgRef, salesPointRef).encode());
        context.getResponse().addCookie(authTokenCookie);
        return "false";
    }
}

