/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.authorization.login;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.authorization.login.B2BAuthConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.B2BLoginParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.SelectPreferencesParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.Employer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.EmployerType;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SelectedPreferencesValidator
extends BaseProcessor {
    public void process(MessageContext ctx) {
        PersonCommunication email;
        EntityReference orgRef;
        Set<OrganizationType> orgTypes;
        List<PersonEmployment> validEmployments;
        SelectPreferencesParameters params = (SelectPreferencesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer loginAgentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER);
        PersonType personType = params.getPersonType();
        EmployerType employerType = Optional.ofNullable(params.getEmployer()).map(Employer::getType).orElse(null);
        String organization = "";
        Person user = (Person)loginAgentCtr.getEntity();
        if (personType == null) {
            Set personTypes = ((Person)loginAgentCtr.getEntity()).getTypes().stream().filter(AuthorizationHelper.VALID_B2B_TYPES_CRITERION).collect(Collectors.toSet());
            if (personTypes.size() == 1) {
                personType = (PersonType)personTypes.iterator().next();
                params.setPersonType(personType);
            } else {
                params.getValidationContext().getPersonTypeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            }
        }
        if ((validEmployments = AuthorizationHelper.getValidEmployments(user)).isEmpty()) {
            throw Xeption.forAdmin((String)"\u0414\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b.", (Object[])new Object[0]);
        }
        if (params.getEmployer() == null) {
            if (validEmployments.size() > 1) {
                params.getValidationContext().getEmployerValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            } else {
                params.setEmployer(B2BAuthConverterHelper.convertOrganizationRef2RestEmployer((EntityReference<Organization>)validEmployments.get(0).getOrganization()));
            }
        } else {
            Set validEmpOrgUids = validEmployments.stream().map(PersonEmployment::getOrganization).filter(Objects::nonNull).map(EntityReference::getUid).collect(Collectors.toSet());
            if (!validEmpOrgUids.contains(params.getEmployer().getUid())) {
                params.getValidationContext().getEmployerValidationMessages().add(StandardValidationMessages.getWrongValue());
            }
        }
        if (params.getEmployer() != null && (personType == null || employerType == null) && employerType == null && (employerType = CabinetConverterHelper.convertOrganizationType2EmployerType(orgTypes = CabinetHelper.getOrganizationTypes((EntityReference<Organization>)(orgRef = new EntityReference(params.getEmployer().getUid(), Organization.class, params.getEmployer().getCaption()))), (EntityReference<Organization>)orgRef)) == null) {
            organization = orgTypes.toString();
        }
        if (user != null && (email = (PersonCommunication)user.getCommunications().stream().filter(pc -> CommunicationType.EMAIL == pc.getType()).findFirst().orElse(null)) == null) {
            throw Xeption.forAdmin((String)String.format("\u0412 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f [%s] \u043d\u0435 \u0437\u0430\u0434\u0430\u043d email.", user.getLoginName()), (Object[])new Object[0]);
        }
        if (personType != null && !this.isUserRoleCompatibleWithPlaceOfWork(personType, employerType)) {
            String s = employerType != null ? employerType.toString() : organization;
            params.getValidationContext().getEmployerValidationMessages().add(B2BLoginParametersValidationMessages.getUserRoleIncompatibleWithPlaceOfWork((String)personType.toString(), (String)s));
            params.getValidationContext().getPersonTypeValidationMessages().add(B2BLoginParametersValidationMessages.getUserRoleIncompatibleWithPlaceOfWork((String)personType.toString(), (String)s));
        }
        if (!ValidationHelper.isValid((Validatable)params)) {
            throw new ValidationException();
        }
    }

    private boolean isUserRoleCompatibleWithPlaceOfWork(PersonType personType, EmployerType employerType) {
        if (personType == PersonType.AGENT || personType == PersonType.WEB_AGENT) {
            return employerType == EmployerType.AGENCY || employerType == EmployerType.MAIN_AGENCY;
        }
        return personType == PersonType.PASSENGER && employerType == EmployerType.CORPORATE_CLIENT;
    }
}

