/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.authorization.recovery;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.recovery.SendRecoveryTokenProcessor;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.AuthorizationValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.authorization.LoginParameters;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class B2BSendRecoveryTokenProcessor
extends SendRecoveryTokenProcessor {
    @Override
    protected String getRecoveryEmail(LoginParameters parameters, SMSiteType siteType) throws Exception {
        if (siteType == SMSiteType.B2C) {
            return parameters.getLogin();
        }
        EntityContainer<Person> agentCtr = AuthorizationHelper.findProfileByLogin(parameters.getLogin());
        Optional<String> optional = ((Person)agentCtr.getEntity()).getCommunications().stream().filter(comm -> comm.getType() == CommunicationType.EMAIL).map(Communication::getSense).filter(StringUtils::isNotBlank).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        parameters.getValidationContext().getRecoveryEmailValidationMessages().add(AuthorizationValidationMessages.getEmptyRecoveryMail());
        throw new ValidationException();
    }
}

