/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete;

import com.gridnine.xtrip.common.gds.model.GetAviaLocationsRequest;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GetLocationsResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class AutocompleteCombineSearchProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetAviaLocationsRequest request = (GetAviaLocationsRequest)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GET_AVIA_LOCATIONS_REQUEST);
        Locale locale = LocaleManager.get().getCurrentLocale();
        int limit = 10;
        if (request.getLimit() != null) {
            if (request.getLimit() <= 0) {
                throw Xeption.forDeveloper((String)"limit <= 0", (Object[])new Object[0]);
            }
            if (request.getLimit() > 1000) {
                throw Xeption.forDeveloper((String)"limit > 1000", (Object[])new Object[0]);
            }
            limit = request.getLimit();
        }
        List<GeoLocation> resultLocations = this.filterCitiesWithoutAirportOrRailStations(this.searchCitiesFromPattern(request.getPattern(), locale)).stream().limit(limit).collect(Collectors.toList());
        GetLocationsResult result = new GetLocationsResult();
        resultLocations.forEach(location -> result.getLocations().add(AviaConverterHelper.convertGeoLocationReference2Rest(location, locale)));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    protected List<GeoLocation> searchCitiesFromPattern(String pattern, Locale locale) {
        HashSet searchResult = new HashSet();
        searchResult.addAll(DictionaryCache.get().search(GeoLocation.class, pattern.toLowerCase(locale)));
        searchResult.addAll(DictionaryCache.get().lookup(GeoLocation.class, pattern, new String[0]));
        searchResult.addAll(DictionaryCache.get().lookup(GeoLocation.class, pattern.toUpperCase(locale), new String[0]));
        HashSet countrySearchResult = new HashSet();
        countrySearchResult.addAll(DictionaryCache.get().search(Country.class, pattern.toLowerCase(locale)));
        countrySearchResult.addAll(DictionaryCache.get().lookup(Country.class, pattern.toUpperCase(locale), new String[0]));
        for (Country country : countrySearchResult) {
            searchResult.addAll(DictionaryCache.get().search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.country.name(), (Object)country.toReference())));
        }
        return searchResult.stream().filter(l -> l.getType() == LocationType.CITY).sorted((loc1, loc2) -> {
            String c1 = loc1.getCountry().getCode();
            String c2 = loc2.getCountry().getCode();
            if (c1.equals(locale.getCountry()) && c2.equals(locale.getCountry())) {
                return 0;
            }
            if (!c2.equals(locale.getCountry())) {
                return -1;
            }
            return 1;
        }).collect(Collectors.toList());
    }

    private List<GeoLocation> filterCitiesWithoutAirportOrRailStations(List<GeoLocation> locations) {
        ArrayList<GeoLocation> result = new ArrayList<GeoLocation>();
        for (GeoLocation location : locations) {
            Set railwayStations = DictionaryCache.get().search(RailwayStation.class, DictSearchCriterion.eq((String)RailwayStation.Property.geoLocation.name(), (Object)location.toReference()));
            Set airports = DictionaryCache.get().search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.parent.name(), (Object)location.toReference()));
            if (railwayStations.isEmpty() && airports.isEmpty()) continue;
            result.add(location);
        }
        return result;
    }
}

