/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AutocompleteHelper {
    public static List<String> getTransliteratedTerms(String term) throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        if (TextUtil.isCyrillic((String)term, (boolean)true)) {
            res.add(TranslitUtil.cyr2lat((String)term, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE));
            res.add(TranslitUtil.cyr2lat((String)term, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006));
            res.add(TranslitUtil.cyr2lat((String)term, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.SIRENA));
        } else {
            res.add(TextUtil.translit((String)term, (boolean)false));
        }
        res.add(IBusGdsHelper.getNewPattern((String)term).toString());
        return res;
    }

    public static Comparator<EntityReference> compareReferenceByCaption() {
        return (r1, r2) -> {
            boolean b1 = StringUtils.isNotBlank((String)r1.getCaption());
            boolean b2 = StringUtils.isNotBlank((String)r2.getCaption());
            if (b1 && b2) {
                return r1.getCaption().toUpperCase().compareTo(r2.getCaption().toUpperCase());
            }
            if (b1) {
                return -1;
            }
            return 1;
        };
    }

    public static void addPersonIndexNamePatternCriterions(SearchQuery searchQuery, String pattern) {
        SearchCriterion patternCriterion = AutocompleteHelper.buildPersonIndexNamePatternCriterion(pattern);
        if (patternCriterion != null) {
            searchQuery.getCriteria().getCriterions().add(patternCriterion);
        }
    }

    public static SearchCriterion buildPersonIndexNamePatternCriterion(String pattern) {
        if (TextUtil.isBlank((String)pattern)) {
            return null;
        }
        String[] patternParts = pattern.split("\\s+");
        String firstNamePattern = null;
        String middleNamePattern = null;
        String lastNamePattern = patternParts[0];
        if (patternParts.length >= 2) {
            firstNamePattern = patternParts[1];
        }
        if (patternParts.length >= 3) {
            middleNamePattern = "%" + patternParts[2] + "%";
        }
        if (firstNamePattern == null) {
            lastNamePattern = "%" + lastNamePattern + "%";
        } else if (middleNamePattern == null) {
            firstNamePattern = "%" + firstNamePattern + "%";
        }
        ArrayList<SearchCriterion> addCriterions = new ArrayList<SearchCriterion>();
        if (!TextUtil.isBlank((String)lastNamePattern)) {
            addCriterions.add(SearchCriterion.icontains((String)PersonIndex.Property.lastNameValues.name(), (String)lastNamePattern));
        }
        if (!TextUtil.isBlank((String)firstNamePattern)) {
            addCriterions.add(SearchCriterion.icontains((String)PersonIndex.Property.firstNameValues.name(), (String)firstNamePattern));
        }
        if (!TextUtil.isBlank((String)middleNamePattern)) {
            addCriterions.add(SearchCriterion.icontains((String)PersonIndex.Property.middleNameValues.name(), (String)middleNamePattern));
        }
        if (addCriterions.isEmpty()) {
            return null;
        }
        return SearchQueryHelper.toAndCriterion(addCriterions);
    }
}

