/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete;

import com.gridnine.xtrip.common.hotels2.model.HotelSummary;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.autocomplete.HotelInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.autocomplete.LocationsAutocompleteParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.autocomplete.LocationsAutocompleteResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GeoLocationReference;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GetLocationsResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.RoutePoint;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.ServiceType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class AutocompleteResponseConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        LocationsAutocompleteResult result = new LocationsAutocompleteResult();
        LocationsAutocompleteParameters params = (LocationsAutocompleteParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ServiceType type = params.getSearchType();
        Locale locale = TextUtil.isBlank((String)params.getLocale()) ? LocaleHelper.getCurrentLocale() : LocaleUtil.createNormalizedLocale((String)params.getLocale());
        switch (type) {
            case AVIA: 
            case COMBINED: {
                GetLocationsResult res = (GetLocationsResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
                res.getLocations().forEach(loc -> {
                    RoutePoint point = new RoutePoint();
                    point.setCaption(TextUtil.isBlank((String)loc.getAirportCaption()) ? loc.getCityCaption() : this.buildAirportCaption((GeoLocationReference)loc));
                    point.setCode(TextUtil.isBlank((String)loc.getIataCode()) ? loc.getCrtCode() : loc.getIataCode());
                    result.getLocations().add(point);
                });
                break;
            }
            case RAIL: {
                List stations = (List)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
                stations.forEach(st -> {
                    RoutePoint point = new RoutePoint();
                    point.setCode(st.getUid());
                    point.setCaption(st.getCaption());
                    result.getLocations().add(point);
                });
                break;
            }
            case HOTEL: {
                List locations = (List)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_CITIES_SUMMARY_LIST);
                List hotelSummaryList = (List)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_SUMMARY_LIST);
                hotelSummaryList.stream().map(this::convertToHotelInfo).forEach(info -> result.getHotels().add(info));
                locations.forEach(pair -> {
                    DictionaryReference<GeoLocation> modifiedLocRef = SiteConverterHelper.buildHotelGeoLocationReference((MiscUtil.Pair<GeoLocation, String>)pair, locale);
                    if (modifiedLocRef != null) {
                        RoutePoint point = new RoutePoint();
                        point.setCaption(modifiedLocRef.getCaption());
                        point.setCode(modifiedLocRef.getCode());
                        point.setLatitude(Double.valueOf(((GeoLocation)pair.getFirst()).getLatitude()));
                        point.setLongitude(Double.valueOf(((GeoLocation)pair.getFirst()).getLongitude()));
                        result.getLocations().add(point);
                    }
                });
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private String buildAirportCaption(GeoLocationReference location) {
        if (TextUtil.isBlank((String)location.getCityCaption())) {
            return location.getAirportCaption();
        }
        List<String> cityCaptionParts = Arrays.asList(location.getCityCaption().split("[,()]"));
        boolean captionsMatches = Arrays.stream(location.getAirportCaption().split("[,()]")).anyMatch(cityCaptionParts::contains);
        return captionsMatches ? location.getAirportCaption() : location.getCityCaption() + ", " + location.getAirportCaption();
    }

    private HotelInfo convertToHotelInfo(HotelSummary summary) {
        HotelInfo info = new HotelInfo();
        info.setNumber(summary.getNumber());
        info.setName(summary.getName());
        info.setCity(summary.getAddress().getCity());
        info.setCountry(summary.getAddress().getCountry());
        info.setHotelStars(summary.getHotelStars());
        info.setLatitude(summary.getLatitude());
        info.setLongitude(summary.getLongitude());
        return info;
    }
}

