/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.bookingFormContacts;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.AutocompleteHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.autocomplete.BookingFormContactData;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.autocomplete.BookingFormContactsAutocompleteParameters;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class AutocompleteBookingFormContactsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BookingFormContactsAutocompleteParameters params = (BookingFormContactsAutocompleteParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference authorizedUserRef = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        PersonType authorizedUserType = (PersonType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_PERSON_TYPE);
        SearchQuery searchQuery = new SearchQuery();
        AutocompleteHelper.addPersonIndexNamePatternCriterions(searchQuery, params.getPattern());
        String clientUid = params.getClientUid();
        if (!"null".equals(clientUid) && TextUtil.nonBlank((String)clientUid)) {
            SearchCriterion clientCriterion;
            EntityContainer clientCtr = EntityStorage.get().resolve(new EntityReference(clientUid, Organization.class, null));
            if (clientCtr == null) {
                throw Xeption.forDeveloper((String)"clientUid is invalid", (Object[])new Object[0]);
            }
            EntityReference holdingRef = ((Organization)clientCtr.getEntity()).getHolding();
            boolean addAthUser = authorizedUserRef != null && authorizedUserType != PersonType.AGENT;
            SearchCriterion searchCriterion = clientCriterion = holdingRef != null ? SearchCriterion.contains((String)PersonIndex.Property.holdings.name(), (Object)holdingRef) : SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)clientUid);
            if (addAthUser) {
                clientCriterion = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{clientCriterion, SearchCriterion.eq((String)"containerUid", (Object)authorizedUserRef.getUid())});
            }
            searchQuery.getCriteria().getCriterions().add(clientCriterion);
        }
        if (params.getLimit() != null) {
            searchQuery.setLimit(params.getLimit().intValue());
        }
        searchQuery.getPreferredProperties().add("containerUid");
        List<PersonIndex> data = IbePermissionManager.secureSearch(PersonIndex.class, searchQuery);
        ArrayList result = new ArrayList();
        data.stream().map(PersonIndex::getSource).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).map(this::buildBookingFormContactData).filter(contactData -> TextUtil.nonBlank((String)contactData.getLastName())).sorted(Comparator.comparing(BookingFormContactData::getLastName).thenComparing(BookingFormContactData::getFirstName)).forEach(result::add);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, result);
    }

    private BookingFormContactData buildBookingFormContactData(EntityContainer<Person> personCtr) {
        BookingFormContactData result = new BookingFormContactData();
        Person person = (Person)personCtr.getEntity();
        result.setLastName(L10nStringHelper.getValue((L10nString)person.getLastName()));
        result.setFirstName(L10nStringHelper.getValue((L10nString)person.getFirstName()));
        result.setEmail(CommonConverterHelper.convertEmailCommunication2Rest(person.getCommunications()));
        result.setPhone(CommonConverterHelper.convertPhoneCommunication2Rest(person.getCommunications()));
        result.setPersonRef(personCtr.toReference());
        return result;
    }
}

