/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.convertRoutePoints;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.autocomplete.ConvertRoutePointsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.autocomplete.ConvertRoutePointsResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GeoLocationReference;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.RoutePoint;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ConvertRoutePointsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        ConvertRoutePointsParameters params = (ConvertRoutePointsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        ConvertRoutePointsResult result = new ConvertRoutePointsResult();
        block0 : switch (params.getCurrentRoutePointsType()) {
            case AVIA: {
                switch (params.getNeededRoutePointsType()) {
                    case RAIL: {
                        this.convertAvia2Rail(params.getRoutePoints(), result.getRoutePoints());
                        break;
                    }
                    case COMBINED: {
                        this.convertSameRoutePointsToMap(params.getRoutePoints(), result.getRoutePoints());
                    }
                }
                break;
            }
            case RAIL: {
                switch (params.getNeededRoutePointsType()) {
                    case COMBINED: 
                    case AVIA: {
                        this.convertRail2Avia(params.getRoutePoints(), result.getRoutePoints());
                    }
                }
                break;
            }
            case COMBINED: {
                switch (params.getNeededRoutePointsType()) {
                    case RAIL: {
                        this.convertAvia2Rail(params.getRoutePoints(), result.getRoutePoints());
                        break block0;
                    }
                    case AVIA: {
                        this.convertSameRoutePointsToMap(params.getRoutePoints(), result.getRoutePoints());
                    }
                }
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private void convertAvia2Rail(List<RoutePoint> routePoints, Map<String, RoutePoint> result) {
        for (int i = 0; i < routePoints.size(); ++i) {
            RoutePoint rp = routePoints.get(i);
            RailwayStation railwayStation = B2BRestHelper.getMostRelevantRailwayStation(B2BRestHelper.getRailwayStationsFromGeolocationCode(rp.getCode()));
            if (railwayStation == null) continue;
            RoutePoint routePoint = new RoutePoint();
            routePoint.setCode(railwayStation.getCode());
            routePoint.setCaption((String)railwayStation.getTranslations().get(LocaleUtil.createNormalizedLocale((Locale)LocaleHelper.getCurrentLocale())));
            result.put(String.valueOf(i), routePoint);
        }
    }

    private void convertRail2Avia(List<RoutePoint> routePoints, Map<String, RoutePoint> result) {
        for (int i = 0; i < routePoints.size(); ++i) {
            GeoLocation geoLocation;
            RoutePoint rp = routePoints.get(i);
            RailwayStation railwayStation = (RailwayStation)DictionaryCache.get().findByCode(RailwayStation.class, rp.getCode());
            if (railwayStation == null || (geoLocation = (GeoLocation)DictHelper.resolve((DictionaryReference)railwayStation.getGeoLocation())) == null) continue;
            GeoLocationReference loc = AviaConverterHelper.convertGeoLocationReference2Rest(geoLocation, LocaleHelper.getCurrentLocale());
            RoutePoint routePoint = new RoutePoint();
            routePoint.setCaption(loc.getCityCaption());
            routePoint.setCode(TextUtil.isBlank((String)loc.getIataCode()) ? loc.getCrtCode() : loc.getIataCode());
            result.put(String.valueOf(i), routePoint);
        }
    }

    private void convertSameRoutePointsToMap(List<RoutePoint> routePoints, Map<String, RoutePoint> result) {
        for (int i = 0; i < routePoints.size(); ++i) {
            result.put(String.valueOf(i), routePoints.get(i));
        }
    }
}

