/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmploymentIndex;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.AutocompleteHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.autocomplete.EmployeesAutocompleteParameters;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class AutocompleteEmployeeProcessor
extends BaseProcessor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"dd.MM.yyyy");

    public void process(MessageContext ctx) throws Exception {
        EmployeesAutocompleteParameters params = (EmployeesAutocompleteParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String pattern = params.getPattern() == null ? "" : params.getPattern();
        int limit = params.getLimit() == null ? 10 : params.getLimit();
        String orgUid = params.getUid();
        if (pattern.length() < 2) {
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, Collections.emptyList());
            return;
        }
        EntityContainer corpClient = EntityStorage.get().load(Organization.class, orgUid);
        if (EntityStorageHelper.isEmpty((EntityContainer)corpClient)) {
            throw Xeption.forDeveloper((String)"can't find organization with uid {0}", (Object[])new Object[]{orgUid});
        }
        boolean useEnglishNames = !TextUtil.isBlank((String)pattern) && !TextUtil.containsCyrillicLetter((String)pattern);
        List<PersonIndex> personIndexList = this.getEmployeesFromOrganization(orgUid, Collections.singleton(pattern), useEnglishNames);
        if (personIndexList.isEmpty() && TextUtil.nonBlank((String)pattern)) {
            Set<String> patterns = AutocompleteHelper.getTransliteratedTerms(pattern).stream().filter(TextUtil::nonBlank).collect(Collectors.toSet());
            useEnglishNames = false;
            personIndexList = this.getEmployeesFromOrganization(orgUid, patterns, useEnglishNames);
        }
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        boolean finalUseEnglishNames = useEnglishNames;
        personIndexList.stream().map(pi -> AutocompleteEmployeeProcessor.convertToReference(pi, finalUseEnglishNames)).forEach(result::add);
        result.sort(AutocompleteHelper.compareReferenceByCaption());
        while (result.size() > limit) {
            result.remove(result.size() - 1);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, result);
    }

    private List<PersonIndex> getEmployeesFromOrganization(String orgUid, Collection<String> patterns, boolean useEnglishNames) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)orgUid));
        List patternCriterions = patterns.stream().map(AutocompleteHelper::buildPersonIndexNamePatternCriterion).filter(Objects::nonNull).collect(Collectors.toList());
        if (!patternCriterions.isEmpty()) {
            query.getCriteria().getCriterions().add(SearchQueryHelper.toOrCriterion(patternCriterions));
        }
        query.getPreferredProperties().add(PersonIndex.Property.name.name());
        query.getPreferredProperties().add(PersonIndex.Property.birthday.name());
        query.getPreferredProperties().add(PersonIndex.Property.englishLastName.name());
        query.getPreferredProperties().add(PersonIndex.Property.englishFirstName.name());
        query.getPreferredProperties().add(PersonIndex.Property.englishMiddleName.name());
        if (useEnglishNames) {
            query.getCriteria().getOrders().put(PersonIndex.Property.englishLastName.name(), SortOrder.ASC);
            query.getCriteria().getOrders().put(PersonIndex.Property.englishFirstName.name(), SortOrder.ASC);
            query.getCriteria().getOrders().put(PersonIndex.Property.englishMiddleName.name(), SortOrder.ASC);
        } else {
            query.getCriteria().getOrders().put(PersonIndex.Property.name.name(), SortOrder.ASC);
        }
        List<PersonIndex> personIndexList = IbePermissionManager.secureSearch(PersonIndex.class, query);
        SearchQuery queryEmployments = new SearchQuery();
        queryEmployments.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonEmploymentIndex.Property.organization.name(), (Object)orgUid));
        queryEmployments.getCriteria().getCriterions().add(SearchCriterion.le((String)PersonEmploymentIndex.Property.workEndDate.name(), (Object)new Date()));
        Set inactiveEmployedPersons = EntityStorage.get().search(PersonEmploymentIndex.class, queryEmployments).getData().stream().map(PersonEmploymentIndex::getSource).collect(Collectors.toSet());
        personIndexList.removeIf(idx -> inactiveEmployedPersons.contains(idx.getSource()));
        return personIndexList;
    }

    private static EntityReference<Person> convertToReference(PersonIndex pi, boolean useEnglishNames) {
        EntityReference result = pi.getSource();
        StringBuilder caption = new StringBuilder();
        if (useEnglishNames) {
            String englishName = Stream.of(pi.getEnglishLastName(), pi.getEnglishFirstName(), pi.getEnglishMiddleName()).filter(TextUtil::nonBlank).collect(Collectors.joining(" "));
            caption.append(WordUtils.capitalize((String)englishName.toLowerCase()));
        } else {
            caption.append(pi.getName());
        }
        if (pi.getBirthday() != null) {
            caption.append(" (").append(DF.format(pi.getBirthday())).append(")");
        }
        result.setCaption(caption.toString());
        return result;
    }
}

