/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.AutocompleteHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.OrganizationsAutocompleteParams;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AutocompleteOrganizationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference currentOrg = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        EntityReference currentPerson = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        OrganizationsAutocompleteParams params = (OrganizationsAutocompleteParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String pattern = params.getPattern() == null ? "" : params.getPattern();
        int limit = params.getLimit() == null ? 100 : params.getLimit();
        boolean useAcl = params.isUseAcl();
        boolean findAgency = params.isFindOnlyAgencies();
        TreeSet<EntityReference<Organization>> tempResult = new TreeSet<EntityReference<Organization>>(AutocompleteHelper.compareReferenceByCaption());
        EntityContainer personContainer = EntityStorage.get().resolve(currentPerson);
        Set<EntityReference<Organization>> organizations = findAgency ? AutocompleteOrganizationProcessor.findSubagencies((EntityContainer<Person>)personContainer) : (useAcl ? AutocompleteOrganizationProcessor.getOrganizations((EntityContainer<Person>)personContainer) : CorporateClientHelper.getCorporateClients((EntityReference<Organization>)currentOrg, true));
        if (params.isWithoutRetailClient() && ProfileHelper.getRetailProfileContainer() != null) {
            organizations.remove(ProfileHelper.getRetailProfileContainer().toReference());
        }
        AutocompleteOrganizationProcessor.filterClientsByPattern(organizations, tempResult, params.getLocale(), pattern);
        if (tempResult.isEmpty()) {
            AutocompleteHelper.getTransliteratedTerms(pattern).forEach(pat -> AutocompleteOrganizationProcessor.filterClientsByPattern(organizations, tempResult, params.getLocale(), pat));
        }
        List result = tempResult.stream().limit(limit).collect(Collectors.toList());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, result);
    }

    private static Set<EntityReference<Organization>> findSubagencies(EntityContainer<Person> personCtr) {
        Set employmentOrganizationUids = ((Person)personCtr.getEntity()).getEmployments().stream().map(PersonEmployment::getOrganization).map(EntityReference::getUid).collect(Collectors.toSet());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"containerUid", employmentOrganizationUids));
        return EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().map(OrganizationIndex::getSource).collect(Collectors.toSet());
    }

    private static void filterClientsByPattern(Set<EntityReference<Organization>> clients, Set<EntityReference<Organization>> result, String locale, String pattern) {
        clients.stream().map(client -> EntityStorage.get().resolve(client)).filter(Objects::nonNull).filter(AutocompleteOrganizationProcessor.filterByPattern(locale, pattern)).forEach(org -> result.add(org.toReference()));
    }

    private static Predicate<EntityContainer<Organization>> filterByPattern(String locale, String pattern) {
        return ctr -> {
            Organization client = (Organization)ctr.getEntity();
            Locale loc = LocaleUtil.createNormalizedLocale((String)locale);
            String shortName = client.getShortName().toString(loc);
            String fullName = client.getFullName().toString(loc);
            String aggregatedName = "";
            if (shortName != null) {
                aggregatedName = aggregatedName + shortName.toUpperCase();
            }
            if (fullName != null) {
                aggregatedName = aggregatedName + fullName.toUpperCase();
            }
            return aggregatedName.contains(pattern != null ? pattern.toUpperCase() : "");
        };
    }

    private static Set<EntityReference<Organization>> getOrganizations(EntityContainer<Person> personContainer) throws Exception {
        String login = ((Person)personContainer.getEntity()).getLoginName();
        if (AclHelper.isGranted(null, (String)OrganizationIndex.class.getName(), (String)login, (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList())) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT), SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY)}));
            AclHelper.modifyQuery((SearchQuery)query, (String)OrganizationIndex.class.getName(), (String)login, Collections.emptyList());
            return EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().map(OrganizationIndex::getSource).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

