/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.PersonRestCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.RestCostCodeCategoryUid;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.http.util.TextUtils;

public class CorporateClientHelper {
    public static Set<EntityReference<Organization>> getCorporateClients(EntityReference<Organization> organizationReference) {
        return CorporateClientHelper.getCorporateClients(organizationReference, false);
    }

    public static Set<EntityReference<Organization>> getCorporateClients(EntityReference<Organization> organizationReference, boolean withAcl) {
        EntityContainer organization = EntityStorage.get().resolve(organizationReference);
        return ((Organization)organization.getEntity()).getTypes().contains(OrganizationType.AGENCY) ? CorporateClientHelper.getCorporateClientsFromOrganization((EntityContainer<Organization>)organization) : CorporateClientHelper.getHoldingCompaniesFromCorporateClient((EntityContainer<Organization>)organization, withAcl);
    }

    private static Set<EntityReference<Organization>> getCorporateClientsFromOrganization(EntityContainer<Organization> organization) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.disabled.name(), (Object)false), SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)organization.getUid()), SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.CLIENT)}));
        List searchResult = EntityStorage.get().search(ContractIndex.class, query).getData();
        Date currentDate = new Date();
        Set<EntityReference<Organization>> orgSet = searchResult.stream().filter(c -> c.getCustomer() != null).filter(c -> c.getStartDate() == null || currentDate.after(c.getStartDate())).filter(c -> c.getEndDate() == null || currentDate.before(c.getEndDate())).map(ContractIndex::getCustomer).collect(Collectors.toSet());
        if (ProfileHelper.getRetailProfileContainer() != null) {
            orgSet.add((EntityReference<Organization>)ProfileHelper.getRetailProfileContainer().toReference());
        }
        return orgSet;
    }

    private static Set<EntityReference<Organization>> getHoldingCompaniesFromCorporateClient(EntityContainer<Organization> organization, boolean withAcl) {
        HashSet<EntityReference<Organization>> result = new HashSet<EntityReference<Organization>>();
        result.add(organization.toReference());
        if (((Organization)organization.getEntity()).getHolding() == null) {
            return result;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.holding.toString(), (Object)((Organization)organization.getEntity()).getHolding().getUid()));
        if (withAcl) {
            try {
                AclHelper.modifyQuery((SearchQuery)query, (String)OrganizationIndex.class.getName(), (String)ProfileHelper.getLogin(), Collections.emptyList());
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"AclHelper.modifyQuery failed", (Throwable)e, (Object[])new Object[0]);
            }
        }
        List searchResult = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        result.addAll(searchResult.stream().map(OrganizationIndex::getSource).collect(Collectors.toSet()));
        return result;
    }

    public static boolean hasOrganizationCorporateClients(EntityContainer<Organization> organization) {
        return !CorporateClientHelper.getCorporateClientsFromOrganization(organization).isEmpty();
    }

    public static List<PersonCostCode> convertPersonRestCostCodes(List<PersonRestCostCode> restCostCodes, EntityReference<Organization> costCodesOwnerRef, EntityReference<Person> personRef) {
        return CorporateClientHelper.convertPersonRestCostCodes(restCostCodes, (EntityContainer<Organization>)EntityStorage.get().resolve(costCodesOwnerRef), (EntityContainer<Person>)EntityStorage.get().resolve(personRef), RestBookingHelper.REST_PERSON_COST_CODE_VALUES_EQUATOR, (cc, rcc) -> {
            cc.setValue(rcc.getValue());
            cc.setEnglishValue(rcc.getValue());
            cc.setLocalValue(rcc.getValue());
        });
    }

    public static <RCC extends RestCostCodeCategoryUid> List<PersonCostCode> convertPersonRestCostCodes(List<RCC> restCostCodes, EntityContainer<Organization> costCodeOwnerCtr, BiPredicate<CostCode, RCC> sameCostCode, BiConsumer<PersonCostCode, RCC> setValues) {
        return CorporateClientHelper.convertPersonRestCostCodes(restCostCodes, costCodeOwnerCtr, null, sameCostCode, setValues);
    }

    public static <RCC extends RestCostCodeCategoryUid> List<PersonCostCode> convertPersonRestCostCodes(List<RCC> restCostCodes, EntityContainer<Organization> costCodeOwnerCtr, EntityContainer<Person> personCtr, BiPredicate<CostCode, RCC> sameCostCode, BiConsumer<PersonCostCode, RCC> setValues) {
        return restCostCodes.stream().map(rc -> {
            PersonCostCode code = new PersonCostCode();
            CostCodeProperties props = CorporateClientHelper.getCostCodeProperties(rc, (Organization)costCodeOwnerCtr.getEntity());
            code.setCostCodeProperties(props);
            code.setOrganization(costCodeOwnerCtr.toReference());
            CostCode perCostCode = ((Organization)costCodeOwnerCtr.getEntity()).getCostCodes().stream().filter(cc -> MiscUtil.equals((Object)cc.getCostCodeProperties(), (Object)props)).filter(cc -> sameCostCode.test((CostCode)cc, (Object)rc)).findFirst().orElse(null);
            if (perCostCode == null) {
                perCostCode = Optional.ofNullable(personCtr).map(EntityContainer::getEntity).flatMap(p -> p.getCostCodes().stream().filter(cc -> MiscUtil.equals((Object)cc.getCostCodeProperties(), (Object)props)).filter(cc -> sameCostCode.test((CostCode)cc, (Object)rc)).findFirst()).orElse(null);
            }
            if (perCostCode == null) {
                setValues.accept(code, rc);
            } else {
                code.setValue(perCostCode.getValue());
                code.setLocalValue(perCostCode.getLocalValue());
                code.setEnglishValue(perCostCode.getEnglishValue());
            }
            return code;
        }).collect(Collectors.toList());
    }

    public static CostCodeProperties getCostCodeProperties(RestCostCodeCategoryUid restCostCode, Organization client) {
        return client.getCostCodeProperties().stream().filter(ccp -> ccp.getCategory().getCode().equals(restCostCode.getCostCodeCategoryUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"invalid costCodeCategoryUid {0} for organization {1}", (Object[])new Object[]{restCostCode.getCostCodeCategoryUid(), client.toString()}));
    }

    public static String defineValueFromCostCode(CostCode costCode) {
        if (!TextUtils.isBlank((CharSequence)costCode.getLocalValue())) {
            return costCode.getLocalValue();
        }
        if (!TextUtils.isBlank((CharSequence)costCode.getValue())) {
            return costCode.getValue();
        }
        if (!TextUtils.isBlank((CharSequence)costCode.getEnglishValue())) {
            return costCode.getEnglishValue();
        }
        return null;
    }

    public static List<PersonRestCostCode> convertPersonCostCodes2Rest(List<PersonCostCode> costCodes) {
        return costCodes.stream().map(cc -> {
            if (cc.getCostCodeProperties() == null) {
                return null;
            }
            PersonRestCostCode personRestCostCode = new PersonRestCostCode();
            personRestCostCode.setName(cc.getCostCodeProperties().getName());
            personRestCostCode.setCostCodeCategoryUid(cc.getCostCodeProperties().getCategory().getCode());
            personRestCostCode.setCommon(cc.getCostCodeProperties().isCommon());
            personRestCostCode.setValue(CorporateClientHelper.defineValueFromCostCode((CostCode)cc));
            return personRestCostCode;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

