/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.passengers;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.StandardAutocompleteParams;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.cabinet.RestPerson;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.List;

public class AutocompleteB2CPassengersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        StandardAutocompleteParams params = (StandardAutocompleteParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference authorizedUser = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        if (authorizedUser == null) {
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, Collections.emptyList());
            return;
        }
        String pattern = params.getPattern();
        if (!TextUtil.isBlank((String)pattern)) {
            pattern = "%" + pattern + "%";
        }
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.parent.name(), (Object)authorizedUser));
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.icontains((String)PersonIndex.Property.types.name(), (String)PersonType.PASSENGER.name()));
        if (!TextUtil.isBlank((String)pattern)) {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)PersonIndex.Property.name.name(), (String)pattern), SearchCriterion.ilike((String)PersonIndex.Property.englishFirstName.name(), (String)pattern), SearchCriterion.ilike((String)PersonIndex.Property.englishLastName.name(), (String)pattern)}));
        }
        SearchResult searchResult = EntityStorage.get().search(PersonIndex.class, searchQuery, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        List<RestPerson> result = CabinetConverterHelper.convertPersons(searchResult.getData());
        result.add(CabinetConverterHelper.convertPerson2Rest((EntityContainer<Person>)EntityStorage.get().resolve(authorizedUser)));
        result.forEach(p -> p.setWithoutMiddleName(false));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, result);
    }
}

