/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.passengers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.AutocompleteHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.StandardAutocompleteParams;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.cabinet.RestPerson;
import com.gridnine.xtrip.server.ibecorp.security.acl.IbePermissionManager;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Optional;

public class AutocompletePassengersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        StandardAutocompleteParams params = (StandardAutocompleteParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String retailProfileUid = Optional.ofNullable(ProfileHelper.findRetailProfileReference()).map(EntityReference::getUid).orElse("");
        SearchQuery searchQuery = new SearchQuery();
        AutocompleteHelper.addPersonIndexNamePatternCriterions(searchQuery, params.getPattern());
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.icontains((String)PersonIndex.Property.types.name(), (String)PersonType.PASSENGER.name()), SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.isEmpty((String)PersonIndex.Property.employments.name()), SearchCriterion.icontains((String)PersonIndex.Property.employmentsUids.name(), (String)retailProfileUid)})}));
        if (params.getLimit() != null) {
            searchQuery.setLimit(params.getLimit().intValue());
        }
        searchQuery.getPreferredProperties().add("containerUid");
        List<PersonIndex> data = IbePermissionManager.secureSearch(PersonIndex.class, searchQuery);
        List<RestPerson> passengers = CabinetConverterHelper.convertPersons(data);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, passengers);
    }
}

