/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.booking.createBooking;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.ibecorp.avia.FlightDataWrapper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BCreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BPassenger;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Passenger;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class B2BCheckSuVoidSameProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        B2BCreateBookingParameters params = (B2BCreateBookingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        FlightDataWrapper wrapper = AviaConverterHelper.convertRestToken2FlightDataWrapper(params.getFlightToken());
        if (!this.isSu((DictionaryReference<Airline>)wrapper.getGdsFlight().getCarrier())) {
            return;
        }
        List flightSegments = wrapper.getGdsFlight().getSegmentTariffs().stream().flatMap(segmentTariff -> segmentTariff.getSegments().stream()).collect(Collectors.toList());
        Set flightNumbers = flightSegments.stream().map(FlightSegment::getFlightNumber).filter(TextUtil::nonBlank).map(number -> number.toUpperCase().trim()).collect(Collectors.toSet());
        Date thirtyMinutesAgo = MiscUtil.addMinutesToDate((Date)new Date(), (int)-30);
        Date departureDate = FlightHelper.getFirstDepartureTime((Flight)wrapper.getGdsFlight());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID_BOOKING));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductIndex.Property.issueDateTime.name(), (Object)thirtyMinutesAgo));
        if (!flightNumbers.isEmpty()) {
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndContainsStringCriterion((String)ProductIndex.Property.flightNos.name(), flightNumbers));
        }
        if (departureDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.between((String)ProductIndex.Property.firstFlightDate.name(), (Object)MiscUtil.clearTime((Date)departureDate), (Object)MiscUtil.setDayEndTime((Date)departureDate)));
        }
        for (ProductIndex index : EntityStorage.get().search(ProductIndex.class, query).getData()) {
            List productSegments;
            Product product;
            EntityContainer bookingFile = EntityStorage.get().resolve(index.getSource());
            if (bookingFile == null || (product = (Product)BookingHelper.findProduct((BookingFile)((BookingFile)bookingFile.getEntity()), (String)index.getNavigationKey(), Product.class)) == null || !this.isSu((DictionaryReference<Airline>)product.getCarrier()) || (productSegments = AirProductHelper.getSegments((Collection)product.getSegmentTariffs())).size() != flightSegments.size() || IntStream.range(0, productSegments.size()).anyMatch(i -> !this.isSameSegment((Segment)productSegments.get(i), (FlightSegment)flightSegments.get(i))) || params.getPassengers().stream().noneMatch(passenger -> this.isSameTraveller(product.getTraveller(), (B2BPassenger)passenger, wrapper.getGdsFlight()))) continue;
            if (params.getPassengers().size() > 1) {
                throw Xeption.forEndUser((String)"\u0412 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} (\u0437\u0430\u043a\u0430\u0437 {1}) \u0434\u043b\u044f \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0430 {2} \u043d\u0430 \u0442\u043e\u0442 \u0436\u0435 \u0440\u0435\u0439\u0441 \u0438 \u0432 \u0442\u043e\u043c \u0436\u0435 \u043a\u043b\u0430\u0441\u0441\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 30 \u043c\u0438\u043d\u0443\u0442 \u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0439 \u0430\u043d\u043d\u0443\u043b\u044f\u0446\u0438\u0438 \u0438\u043b\u0438 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0441 \u043d\u0435\u0439. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u0447\u0435\u0440\u0435\u0437 30 \u043c\u0438\u043d\u0443\u0442", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()), bookingFile.toReference(), product.getTraveller().getName()});
            }
            throw Xeption.forEndUser((String)"\u0412 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} (\u0437\u0430\u043a\u0430\u0437 {1}) \u043d\u0430 \u0442\u043e\u0442 \u0436\u0435 \u0440\u0435\u0439\u0441 \u0438 \u0432 \u0442\u043e\u043c \u0436\u0435 \u043a\u043b\u0430\u0441\u0441\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 30 \u043c\u0438\u043d\u0443\u0442 \u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0439 \u0430\u043d\u043d\u0443\u043b\u044f\u0446\u0438\u0438 \u0438\u043b\u0438 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0441 \u043d\u0435\u0439. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u0447\u0435\u0440\u0435\u0437 30 \u043c\u0438\u043d\u0443\u0442", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()), bookingFile.toReference()});
        }
    }

    private boolean isSu(DictionaryReference<Airline> airlineReference) {
        Airline airline = (Airline)DictionaryCache.get().resolveReference(airlineReference);
        return airline != null && airline.getCodeVariants().containsValue("SU");
    }

    private boolean isSameSegment(Segment segment, FlightSegment flightSegment) {
        return TextUtil.isSame((String)segment.getFlightNo(), (String)flightSegment.getFlightNumber(), (boolean)true) && TextUtil.isSame((String)segment.getClassOfSvcCode(), (String)flightSegment.getBookingClass(), (boolean)true) && MiscUtil.isSameDay((Date)segment.getStartDate(), (Date)flightSegment.getDateBegin());
    }

    private boolean isSameTraveller(Traveller traveller, B2BPassenger passenger, Flight gdsFlight) {
        if (traveller == null) {
            return false;
        }
        Traveller convertedTraveler = AviaConverterHelper.convertRest2Traveler((Passenger)passenger, gdsFlight);
        return TextUtil.isSame((String)traveller.getName(), (String)convertedTraveler.getName(), (boolean)true);
    }
}

