/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.booking.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BCreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BPassenger;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.createBooking.BaseCreateBookingParametersConverter;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Passenger;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDate;

public class B2BCreateBookingParametersConverter
extends BaseCreateBookingParametersConverter<B2BCreateBookingParameters> {
    @Override
    protected Flight getSelectedFlight(String flightToken, MessageContext ctx) {
        return (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
    }

    @Override
    protected void fillAdditionalData(MessageContext ctx, Traveller traveller, Passenger passenger) {
        B2BCreateBookingParameters params = (B2BCreateBookingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Map travellersCostCodes = (Map)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES, HashMap::new);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference clientRef = salesContext.getClient();
        B2BPassenger passengerB2B = (B2BPassenger)passenger;
        traveller.setBirthday(MiscUtil.convertDateFromJoda((LocalDate)passengerB2B.getBirthDate()));
        List<PersonCostCode> costCodes = CorporateClientHelper.convertPersonRestCostCodes(passengerB2B.getCostCodes(), (EntityReference<Organization>)clientRef, (EntityReference<Person>)traveller.getPassenger());
        travellersCostCodes.put(traveller, costCodes);
        if (passenger.getUid() != null) {
            traveller.setPassenger(new EntityReference(passenger.getUid(), Person.class, null));
        }
        ReasonCode reasonCode = CommonConverterHelper.getReasonCode((EntityReference<Organization>)clientRef, params.getReasonCode(), ReasonCodeType.REASON_CODE_AIR);
        ctx.putObject((Enum)IBusIbecorpContextKeys.REASON_CODE, (Object)reasonCode);
        boolean ignoreSabreMealSsr = params.isIgnoreMeal();
        ctx.putObject((Enum)IBusGdsSabreContextKeys.REMOVE_MEAL_SSR, (Object)ignoreSabreMealSsr);
        Map<DictionaryReference<ExternalSystem>, String> externalSystems = B2BRestHelper.convertExternalSystems(params.getExternalSystemCodes());
        ctx.putObject((Enum)IBusIbecorpContextKeys.EXTERNAL_SYSTEMS, externalSystems);
        if (TextUtil.nonBlank((String)params.getBookingToken())) {
            AckMessage productDuplicatesMessage = B2BRestHelper.decodeToken(AckMessage.class, params.getBookingToken());
            ctx.putObject((Enum)IBusAuthorizationContextKeys.PRODUCT_DUPLICATES_MESSAGE, (Object)productDuplicatesMessage);
        }
    }

    @Override
    protected List<B2BPassenger> getPassengers(B2BCreateBookingParameters parameters) {
        return parameters.getPassengers();
    }
}

