/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.booking.createBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.avia.FlightDataWrapper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.IBusRestAviaContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BCreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BPassenger;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.createBooking.BaseCreateBookingParametersValidator;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.List;
import org.joda.time.LocalDate;

public class B2BCreateBookingParametersValidator
extends BaseCreateBookingParametersValidator<B2BCreateBookingParameters> {
    @Override
    public void process(MessageContext ctx) throws Exception {
        ReasonCode reasonCode;
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        B2BCreateBookingParameters parameters = (B2BCreateBookingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        Flight selectedFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        FlightDataWrapper wrapper = (FlightDataWrapper)ctx.getObject((Enum)IBusRestAviaContextKeys.FLIGHT_WRAPPER);
        EntityReference bfRef = null;
        if (wrapper == null && parameters.getFlightToken() != null) {
            wrapper = AviaConverterHelper.convertRestToken2FlightDataWrapper(parameters.getFlightToken());
        }
        if (wrapper != null) {
            bfRef = wrapper.getBookingFile();
        }
        EntityContainer bfCtr = EntityStorage.get().resolve(bfRef);
        EntityReference clientRef = salesContext.getClient();
        Organization client = (Organization)EntityStorage.get().resolve(clientRef).getEntity();
        boolean ruDocsNotAllowed = AviaHelper.isRuDocumentsNotAllowedForFlight(selectedFlight);
        parameters.getPassengers().forEach(pass -> {
            RestPassport restPassport = pass.getPassport();
            if (pass.getBirthDate() == null) {
                pass.getValidationContext().getBirthDateValidationMessages().add(CreateBookingParametersValidationMessages.getMissingBirthDate());
            } else {
                restPassport.setBirthDate(MiscUtil.convertLocalDateFromJoda((LocalDate)pass.getBirthDate()));
            }
            PassportType type = restPassport.getType();
            if (ruDocsNotAllowed && type == PassportType.INTERNAL) {
                restPassport.getValidationContext().getTypeValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalPassportType());
            }
            if (type == PassportType.BIRTHDAY_NOTIFICATION && !this.isBirthdayNotificationAvailableForPassenger(selectedFlight, (B2BPassenger)pass)) {
                restPassport.getValidationContext().getTypeValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalPassportType());
            }
        });
        parameters.getPassengers().forEach(p -> RestBookingHelper.validateRestCodeCodes(p.getCostCodes(), client));
        RestBookingHelper.validateRestCommonCostCodes(parameters.getPassengers(), client, (EntityContainer<BookingFile>)bfCtr);
        if (CommonIbecorpHelper.mustHaveReasonCode((EntityReference)clientRef, (TravelPolicyImpositionResult)selectedFlight.getTravelPolicyImpositionResult(), (ReasonCodeType)ReasonCodeType.REASON_CODE_AIR) && null == (reasonCode = CommonConverterHelper.getReasonCode((EntityReference<Organization>)clientRef, parameters.getReasonCode(), ReasonCodeType.REASON_CODE_AIR))) {
            parameters.getValidationContext().getReasonCodeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (CommonIbecorpHelper.mustHaveKeyContact((TravelPolicyImpositionResult)selectedFlight.getTravelPolicyImpositionResult()) && parameters.getKeyContact() == null) {
            parameters.getValidationContext().getKeyContactValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        super.process(ctx);
    }

    private boolean isBirthdayNotificationAvailableForPassenger(Flight flight, B2BPassenger pass) {
        if (pass.getPassport() == null) {
            return false;
        }
        DictionaryReference countryRef = pass.getPassport().getCitizenship();
        Country country = (Country)DictionaryCache.get().resolveReference(countryRef);
        if (country == null) {
            return false;
        }
        if (!country.getRegions().contains(AirProductHelper.cisRegion)) {
            return false;
        }
        for (FlightSegment segment : FlightHelper.getSegments((Flight)flight)) {
            if (!MiscUtil.equals((Object)countryRef, (Object)DictHelper.getCountry((DictionaryReference)segment.getLocationBegin()))) {
                return false;
            }
            if (MiscUtil.equals((Object)countryRef, (Object)DictHelper.getCountry((DictionaryReference)segment.getLocationEnd()))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Flight getSelectedFlight(String flightToken) {
        FlightDataWrapper wrapper = AviaConverterHelper.convertRestToken2FlightDataWrapper(flightToken);
        return wrapper.getGdsFlight();
    }

    @Override
    protected List<B2BPassenger> getPassengers(B2BCreateBookingParameters parameters) {
        return parameters.getPassengers();
    }

    @Override
    protected Collection<ValidationMessage> getPassengersValidationMessages(B2BCreateBookingParameters parameters) {
        return parameters.getValidationContext().getPassengersValidationMessages();
    }
}

