/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.booking.createBooking;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.avia.FlightDataWrapper;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.IBusRestAviaContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.HasFlightToken;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;

public class B2BExtractTokenProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        HasFlightToken params = (HasFlightToken)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference currentOrg = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        FlightDataWrapper wrapper = AviaConverterHelper.convertRestToken2FlightDataWrapper(params.getFlightToken());
        EntityReference<Organization> client = wrapper.getClient();
        if (client == null) {
            client = B2BRestHelper.getDefaultRetailClientProfileForAgency((EntityReference<Organization>)currentOrg);
        }
        ctx.putObject((Enum)IBusIbecorpContextKeys.SALES_CONTEXT_CLIENT_REF, client);
        ctx.putObject((Enum)IBusRestAviaContextKeys.FLIGHT_WRAPPER, (Object)wrapper);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)wrapper.getGdsFlight());
        if (wrapper.getBookingFile() != null) {
            TripParameters tripParams = new TripParameters();
            tripParams.setBookingFileRef(wrapper.getBookingFile());
            ctx.putObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS, (Object)tripParams);
        }
        if (wrapper.getClient() != null) {
            TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
            travelPolicyParams.setClientRef(wrapper.getClient());
            travelPolicyParams.getPersons().addAll(wrapper.getPassengers());
            ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
        }
    }
}

