/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.booking.getBookingForm;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsCapabilities;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.ibecorp.avia.FlightDataWrapper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.rules.passport.PassportActionSet;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.IBusRestAviaContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingForm.BaseBookingFormSettingsProcessor;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.AviaBookingFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BookingFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BookingFormSettingsParams;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.ibus.rules.PassportRuleHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Objects;

public class AviaBookingFormSettingsProcessor
extends BaseBookingFormSettingsProcessor {
    public void process(MessageContext ctx) throws Exception {
        BookingFormSettingsParams params = (BookingFormSettingsParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference site = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        PersonType authUserType = (PersonType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_PERSON_TYPE);
        FlightDataWrapper wrapper = (FlightDataWrapper)ctx.getMandatoryObject((Enum)IBusRestAviaContextKeys.FLIGHT_WRAPPER);
        GdsCapabilities gdsCapabilities = (GdsCapabilities)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_CAPABILITIES);
        AckMessage searchDuplicatesMessage = (AckMessage)ctx.getObject((Enum)IBusAuthorizationContextKeys.SEARCH_DUPLICATES_MESSAGE);
        RestTraveller restTraveller = params.getTraveller();
        EntityReference clientRef = Objects.requireNonNull(wrapper.getClient());
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        salesContext.setClient(clientRef);
        AviaBookingFormSettings result = new AviaBookingFormSettings();
        result.setBonusCardAvailable(gdsCapabilities.isFqtvBookingSupported());
        this.setSearchDuplicatesMessageData((BookingFormSettings)result, searchDuplicatesMessage);
        CommonConverterHelper.setCustomerAndOrder((BookingFormSettings)result, (EntityReference<BookingFile>)wrapper.getBookingFile());
        BookingFile bookingFile = null;
        if (result.getOrder() != null) {
            bookingFile = (BookingFile)EntityStorage.get().load(BookingFile.class, result.getOrder().getBookingUid()).getEntity();
        }
        result.setContactAutocompleteAvailable(this.isContactAutocompleteAvailable(siteType, (EntityContainer<Organization>)clientCtr));
        result.getCorporatePassengers().addAll(this.getPassengers(bookingFile, wrapper.getPassengers(), wrapper.getGdsFlight().getPassengerTypes(), (EntityReference<Organization>)clientRef));
        result.getOrganizationCostCodes().addAll(RestBookingHelper.getOrganizationCostCodes((EntityContainer<Organization>)clientCtr, restTraveller));
        TravelPolicyImpositionResult tpImpositionResult = wrapper.getGdsFlight().getTravelPolicyImpositionResult();
        result.setReasonCode(AviaBookingFormSettingsProcessor.getReasonCode((EntityContainer<Organization>)clientCtr, tpImpositionResult, ReasonCodeType.REASON_CODE_AIR));
        AviaBookingFormSettingsProcessor.setKeyContact((BookingFormSettings)result, (EntityContainer<Organization>)clientCtr, tpImpositionResult);
        SMStep3Settings thirdStepSettings = CommonHelper.getStep3Settings((EntityReference<SMSite>)site);
        ArrayList<PassportType> types = new ArrayList<PassportType>(Objects.requireNonNull(thirdStepSettings).getAllowedDocuments());
        Flight gdsFlight = wrapper.getGdsFlight();
        DictionaryReference passengerType = restTraveller == null ? DictHelper.getAdultPassengerType() : restTraveller.getType();
        Passport passport = restTraveller == null ? null : AviaConverterHelper.convertRest2PassportForRule(restTraveller.getPassport(), gdsFlight);
        PassportActionSet transliterationRules = PassportRuleHelper.getPassportRules(gdsFlight, (DictionaryReference<PassengerType>)passengerType, passport, salesContext);
        result.setLangRegistrationFullName(AviaHelper.verifyTransliteration(gdsFlight, transliterationRules.getTransliterationTypeFullName()));
        result.setLangRegistrationDocument(AviaHelper.verifyTransliteration(gdsFlight, transliterationRules.getTransliterationTypeDocument()));
        result.setMiddleNameRequired(AviaConverterHelper.isMiddleNameRequired(gdsFlight));
        if (AviaHelper.isRuDocumentsNotAllowedForFlight(gdsFlight)) {
            types.removeIf(type -> type == PassportType.INTERNAL);
            result.getCorporatePassengers().forEach(person -> person.getPassports().removeIf(p -> p.getType() == PassportType.INTERNAL));
        }
        if (!AviaHelper.isInternalCisCountryFlight(gdsFlight)) {
            types.removeIf(type -> type == PassportType.BIRTHDAY_NOTIFICATION);
            result.getCorporatePassengers().forEach(person -> person.getPassports().removeIf(p -> p.getType() == PassportType.BIRTHDAY_NOTIFICATION));
        }
        result.getPassengerTypeDocument().addAll(SiteConverterHelper.getPassengerTypeDocuments(types));
        AviaBookingFormSettingsProcessor.setTravellerData((BookingFormSettings)result, salesContext, TravelSubject.AIR);
        AviaBookingFormSettingsProcessor.setContactPersonData((BookingFormSettings)result, authUserType, salesContext);
        if (bookingFile == null) {
            AviaBookingFormSettingsProcessor.setExternalSystemsData((BookingFormSettings)result, salesContext);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }
}

