/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.booking.priceFlight;

import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.ibecorp.avia.FlightDataWrapper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.selectFlight.B2BSelectFlightResultConverter;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees.RestAncillaryFeesHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BCreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BSelectFlightResult;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.HashMap;
import java.util.Objects;

public class PriceFlightResultProcessor
extends B2BSelectFlightResultConverter {
    @Override
    public void process(MessageContext ctx) throws Exception {
        B2BCreateBookingParameters parameters = (B2BCreateBookingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        FlightDataWrapper dataWrapper = AviaConverterHelper.convertRestToken2FlightDataWrapper(parameters.getFlightToken());
        PriceComponentsParameters priceParameters = this.getPriceConverterParameters(ctx);
        B2BSelectFlightResult result = this.buildSelectFlightResult(dataWrapper, null, flight, (EntityReference<SMSite>)siteRef, siteType, priceParameters);
        this.updatePassengerAncillaryFees(result, parameters);
        result.getFlight().setPrice(AviaPriceComponents.builder(flight, priceParameters).addPassengers(result.getPassengers()).build().createPrice());
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private void updatePassengerAncillaryFees(B2BSelectFlightResult result, B2BCreateBookingParameters parameters) {
        HashMap afDescriptionMap = new HashMap();
        parameters.getPassengers().forEach(p -> p.getAncillaryFees().stream().filter(Objects::nonNull).filter(af -> !afDescriptionMap.containsKey(af.getGdsId())).forEach(af -> {
            AncillaryFeeDescription ancillaryFeeDescription = (AncillaryFeeDescription)DictionaryCache.get().resolveReference(af.getAncFeeDescriptionRef());
            if (ancillaryFeeDescription != null) {
                afDescriptionMap.put(af.getGdsId(), ancillaryFeeDescription);
            }
        }));
        parameters.getPassengers().forEach(travellerAf -> RestAncillaryFeesHelper.updateAncillaryFees(travellerAf.getAncillaryFees(), afDescriptionMap));
        result.getPassengers().clear();
        result.getPassengers().addAll(parameters.getPassengers());
    }
}

