/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.avia.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class B2BSearchFlightsParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        CommonSearchParameters parameters = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference currentOrg = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        FlightSearchParameters flightSearchParameters = new FlightSearchParameters();
        EntityReference<Organization> client = parameters.getClient();
        if (client == null) {
            client = B2BRestHelper.getDefaultRetailClientProfileForAgency((EntityReference<Organization>)currentOrg);
        }
        if (client != null) {
            salesContext.setClient(client);
        }
        ctx.putObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS, (Object)parameters.getPassengers());
        flightSearchParameters.setServiceClass(parameters.getClassOfService());
        flightSearchParameters.getPreferredAirlines().addAll(parameters.getPreferredAirlines());
        flightSearchParameters.setSkipConnected(parameters.isDirect());
        flightSearchParameters.setExcludeBaglessFares(parameters.isExcludeBaglessFares());
        flightSearchParameters.setExcludeMultiTicket(!parameters.isMultiTicket());
        flightSearchParameters.getFlightNumbers().addAll(AviaConverterHelper.buildFlightNumbers(parameters.getFlightNumbers()));
        Date minimumDate = CommonHelper.getMinimumDate((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)));
        flightSearchParameters.getRoute().addAll(parameters.getRoutes().stream().map(route -> {
            RouteSegment seg = new RouteSegment();
            AviaConverterHelper.populateSegment(minimumDate, route, seg);
            return seg;
        }).collect(Collectors.toList()));
        DictionaryReference childType = DictHelper.getChildPassengerType();
        List seats = parameters.getPassengersTypes().entrySet().stream().filter(entry -> !MiscUtil.equals((Object)childType, entry.getKey())).map(e -> this.createSeat((DictionaryReference<PassengerType>)((DictionaryReference)e.getKey()), (Integer)e.getValue())).collect(Collectors.toList());
        flightSearchParameters.getSeats().addAll(seats);
        int childsCount = parameters.getPassengersTypes().getOrDefault(childType, 0);
        Collection childSeats = IntStream.range(0, childsCount).mapToObj(i -> {
            DictionaryReference targetType = childType;
            if (i < parameters.getChildsAge().size()) {
                targetType = DictHelper.getChildPassengerType((int)((Integer)parameters.getChildsAge().get(i)));
            }
            return this.createSeat((DictionaryReference<PassengerType>)targetType, 1);
        }).collect(Collectors.toMap(SeatPreferences::getPassengerType, Function.identity(), (sp1, sp2) -> {
            sp1.setCount(sp1.getCount() + 1);
            return sp1;
        })).values();
        flightSearchParameters.getSeats().addAll(childSeats);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)flightSearchParameters);
        if (parameters.getClient() != null) {
            TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
            travelPolicyParams.setClientRef(parameters.getClient());
            travelPolicyParams.getPersons().addAll(parameters.getPassengers());
            ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
        }
        if (parameters.getBooking() != null) {
            TripParameters tripParams = new TripParameters();
            tripParams.setBookingFileRef(parameters.getBooking());
            ctx.putObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS, (Object)tripParams);
        }
    }

    private SeatPreferences createSeat(DictionaryReference<PassengerType> type, int count) {
        SeatPreferences seatPref = new SeatPreferences();
        seatPref.setPassengerType(type);
        seatPref.setCount(count);
        return seatPref;
    }
}

